/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.justimport.controller;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.unboundid.scim2.common.GenericScimResource;
import com.unboundid.scim2.common.ScimResource;
import com.unboundid.scim2.common.exceptions.BadRequestException;
import com.unboundid.scim2.common.exceptions.NotImplementedException;
import com.unboundid.scim2.common.exceptions.ScimException;
import com.unboundid.scim2.common.exceptions.ServerErrorException;
import com.unboundid.scim2.common.messages.ListResponse;
import com.unboundid.scim2.common.messages.PatchRequest;
import com.unboundid.scim2.common.messages.SearchRequest;
import com.unboundid.scim2.common.messages.SortOrder;
import com.unboundid.scim2.common.types.UserResource;
import com.unboundid.scim2.common.utils.SchemaUtils;
import com.unboundid.scim2.server.utils.ResourceTypeDefinition;
import de.justsoftware.justimport.auth.AuthorizationContext;
import de.justsoftware.justimport.business.model.ValidUserResource;
import de.justsoftware.justimport.business.profile.ScimUsersService;
import de.justsoftware.justimport.controller.ScimRuntimeException;
import de.justsoftware.justimport.util.ResourcePreparer;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import jakarta.annotation.Nullable;
import java.beans.IntrospectionException;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.servlet.support.ServletUriComponentsBuilder;
import org.springframework.web.util.UriComponentsBuilder;

@RestController
@RequestMapping(value={"/api/scim/v2/Users"})
public class ScimUsersController {
    public static final String SCIM_USERS_PATH = "/api/scim/v2/Users";
    public static final ResourceTypeDefinition USER_RESOURCE_TYPE_DEFINITION;
    private static final Logger LOG;
    private final ScimUsersService _userService;

    @Autowired
    public ScimUsersController(ScimUsersService userService) {
        this._userService = userService;
    }

    @GetMapping
    @SuppressFBWarnings(value={"BC_UNCONFIRMED_CAST_OF_RETURN_VALUE"}, justification="Cast is always safe.")
    public ResponseEntity<ListResponse<GenericScimResource>> queryUsers(AuthorizationContext authCtx, @RequestParam(value="attributes", required=false) @Nullable Set<String> attributes, @RequestParam(value="excludedAttributes", required=false) @Nullable Set<String> excludedAttributes, @RequestParam(value="filter", required=false) @Nullable String filter, @RequestParam(value="sortBy", required=false) @Nullable String sortBy, @RequestParam(value="sortOrder", required=false) @Nullable SortOrder sortOrder, @RequestParam(value="startIndex", required=false) @Nullable Integer startIndex, @RequestParam(value="count", required=false) @Nullable Integer count) throws NotImplementedException, BadRequestException {
        if (attributes != null && excludedAttributes != null) {
            throw new BadRequestException("Parameters attributes and excludedAttributes are mutually exclusive.", "invalidFilter");
        }
        SearchRequest request = new SearchRequest(attributes, excludedAttributes, filter, sortBy, sortOrder, startIndex, count);
        List<UserResource> searchResult = this._userService.find(request, authCtx).stream().map(ValidUserResource::asUserResource).toList();
        try {
            List<GenericScimResource> trimmedResources = searchResult.stream().map(user -> {
                try {
                    return this.trimUser(attributes, excludedAttributes, resourcePreparer -> resourcePreparer.trimRetrievedResource((ScimResource)user));
                }
                catch (BadRequestException e) {
                    throw new ScimRuntimeException((Throwable)e);
                }
            }).toList();
            return ResponseEntity.ok((Object)new ListResponse(trimmedResources));
        }
        catch (ScimRuntimeException e) {
            throw (BadRequestException)e.getCause();
        }
    }

    @GetMapping(value={"/{id}"})
    public ResponseEntity<GenericScimResource> getUserById(AuthorizationContext authCtx, @PathVariable(value="id") String id, @RequestParam(value="attributes", required=false) @Nullable Set<String> attributes, @RequestParam(value="excludedAttributes", required=false) @Nullable Set<String> excludedAttributes) throws ScimException {
        UUID uuid = this.parseId(id);
        UserResource user = this._userService.byId(uuid, authCtx).asUserResource();
        return ResponseEntity.ok((Object)this.trimUser(attributes, excludedAttributes, resourcePreparer -> resourcePreparer.trimRetrievedResource((ScimResource)user)));
    }

    @PostMapping
    public ResponseEntity<GenericScimResource> createUser(AuthorizationContext authCtx, @RequestBody UserResource user, @RequestParam(value="attributes", required=false) @Nullable Set<String> attributes, @RequestParam(value="excludedAttributes", required=false) @Nullable Set<String> excludedAttributes) throws ScimException {
        UserResource createdUser = this._userService.create(ValidUserResource.of((UserResource)user), authCtx).asUserResource();
        return new ResponseEntity((Object)this.trimUser(attributes, excludedAttributes, resourcePreparer -> resourcePreparer.trimCreatedResource((ScimResource)createdUser, (ScimResource)user)), (HttpStatusCode)HttpStatus.CREATED);
    }

    @DeleteMapping(value={"/{id}"})
    public ResponseEntity<Void> deleteUserById(@PathVariable(value="id") String id, AuthorizationContext authCtx) throws ScimException {
        UUID uuid = this.parseId(id);
        this._userService.delete(uuid, authCtx);
        return new ResponseEntity((HttpStatusCode)HttpStatus.NO_CONTENT);
    }

    @PatchMapping(value={"/{id}"})
    public ResponseEntity<GenericScimResource> patchUser(AuthorizationContext authCtx, @PathVariable(value="id") String id, @RequestBody PatchRequest request, @RequestParam(value="attributes", required=false) @Nullable Set<String> attributes, @RequestParam(value="excludedAttributes", required=false) @Nullable Set<String> excludedAttributes) throws ScimException {
        UUID uuid = this.parseId(id);
        try {
            UserResource user = this._userService.patch(uuid, request, authCtx).asUserResource();
            return ResponseEntity.ok((Object)this.trimUser(attributes, excludedAttributes, resourcePreparer -> resourcePreparer.trimModifiedResource((ScimResource)user, (Iterable)request.getOperations())));
        }
        catch (JsonProcessingException jsonProcessingException) {
            String msg = String.format("UNKNOWN - could not parse user patch request for user id %s", id);
            LOG.error("{} - message: {}", (Object)msg, (Object)jsonProcessingException.getMessage());
            throw new ServerErrorException(msg);
        }
    }

    @PutMapping(value={"/{id}"})
    public ResponseEntity<GenericScimResource> replaceUser(AuthorizationContext authCtx, @PathVariable(value="id") String id, @RequestBody UserResource user, @RequestParam(value="attributes", required=false) @Nullable Set<String> attributes, @RequestParam(value="excludedAttributes", required=false) @Nullable Set<String> excludedAttributes) throws ScimException {
        UUID uuid = this.parseId(id);
        UserResource updatedUser = this._userService.replace(uuid, ValidUserResource.of((UserResource)user), authCtx).asUserResource();
        return ResponseEntity.ok((Object)this.trimUser(attributes, excludedAttributes, resourcePreparer -> resourcePreparer.trimReplacedResource((ScimResource)updatedUser, (ScimResource)user)));
    }

    private UUID parseId(String id) throws BadRequestException {
        try {
            return UUID.fromString(id);
        }
        catch (IllegalArgumentException e) {
            throw new BadRequestException("Supplied ID is not a UUID", "invalidValue");
        }
    }

    private GenericScimResource trimUser(@Nullable Set<String> attributes, @Nullable Set<String> excludedAttributes, Function<ResourcePreparer<UserResource>, GenericScimResource> trimFunc) throws BadRequestException {
        UriComponentsBuilder uriBuilder = ServletUriComponentsBuilder.fromCurrentContextPath().path(SCIM_USERS_PATH);
        ResourcePreparer resourcePreparer = new ResourcePreparer(USER_RESOURCE_TYPE_DEFINITION, attributes, excludedAttributes, uriBuilder.build(new Object[0]));
        return trimFunc.apply((ResourcePreparer<UserResource>)resourcePreparer);
    }

    static {
        LOG = LoggerFactory.getLogger(ScimUsersController.class);
        try {
            USER_RESOURCE_TYPE_DEFINITION = new ResourceTypeDefinition.Builder("UserResource", SCIM_USERS_PATH).setCoreSchema(SchemaUtils.getSchema(UserResource.class)).build();
        }
        catch (IntrospectionException e) {
            throw new IllegalStateException(e);
        }
    }
}

