/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.justimport.business.usergroup;

import de.justsoftware.justimport.domain.model.common.TenantId;
import de.justsoftware.justimport.domain.model.profile.ProfileId;
import de.justsoftware.justimport.domain.model.usergroup.UserGroupId;
import de.justsoftware.justimport.persistence.model.DbUserGroup;
import de.justsoftware.justimport.persistence.model.ImportMethod;
import java.util.Collection;
import java.util.Set;
import java.util.function.Consumer;

public interface UserGroupImportPublisher {
    public boolean publishImportedUserGroup(TenantId var1, UserGroupId var2, String var3, ImportMethod var4);

    public void publishImportedUserGroup(DbUserGroup var1);

    public void publishDeletedUserGroup(UserGroupId var1);

    public void publishAndCleanAllUserGroupMembers(UserGroupId var1, Set<ProfileId> var2, Consumer<Boolean> var3);

    default public void publishAddedUserGroupMembers(UserGroupId userGroupId, Collection<ProfileId> addedMembers) {
        for (ProfileId memberId : addedMembers) {
            this.publishAddedUserGroupMember(userGroupId, memberId);
        }
    }

    default public void publishAddedUserGroupMembers(Collection<UserGroupId> userGroupIds, ProfileId addedMember) {
        for (UserGroupId userGroupId : userGroupIds) {
            this.publishAddedUserGroupMember(userGroupId, addedMember);
        }
    }

    public void publishAddedUserGroupMember(UserGroupId var1, ProfileId var2);

    default public void publishRemovedUserGroupMembers(UserGroupId userGroupId, Collection<ProfileId> removedMembers) {
        for (ProfileId memberId : removedMembers) {
            this.publishRemovedUserGroupMember(userGroupId, memberId);
        }
    }

    default public void publishRemovedUserGroupMembers(Collection<UserGroupId> userGroupIds, ProfileId removedMember) {
        for (UserGroupId userGroupId : userGroupIds) {
            this.publishRemovedUserGroupMember(userGroupId, removedMember);
        }
    }

    public void publishRemovedUserGroupMember(UserGroupId var1, ProfileId var2);
}

