/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.justimport.business.profile;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.node.ValueNode;
import com.unboundid.scim2.common.exceptions.BadRequestException;
import com.unboundid.scim2.common.exceptions.NotImplementedException;
import com.unboundid.scim2.common.exceptions.PreconditionFailedException;
import com.unboundid.scim2.common.exceptions.ResourceConflictException;
import com.unboundid.scim2.common.exceptions.ResourceNotFoundException;
import com.unboundid.scim2.common.exceptions.ScimException;
import com.unboundid.scim2.common.exceptions.ServerErrorException;
import com.unboundid.scim2.common.filters.Filter;
import com.unboundid.scim2.common.filters.FilterType;
import com.unboundid.scim2.common.messages.PatchRequest;
import com.unboundid.scim2.common.messages.SearchRequest;
import de.justsoftware.justimport.auth.AuthorizationContext;
import de.justsoftware.justimport.business.ToroApiService;
import de.justsoftware.justimport.business.model.ToroProfile;
import de.justsoftware.justimport.business.model.ValidUserResource;
import de.justsoftware.justimport.business.profile.ScimFieldMappingService;
import de.justsoftware.justimport.business.usergroup.UserGroupImportPublisher;
import de.justsoftware.justimport.domain.model.common.TenantId;
import de.justsoftware.justimport.domain.model.profile.ProfileId;
import de.justsoftware.justimport.domain.model.usergroup.UserGroupId;
import de.justsoftware.justimport.persistence.ProfileRepository;
import de.justsoftware.justimport.persistence.ScimUserResourceRepository;
import de.justsoftware.justimport.persistence.UserGroupMemberRepository;
import de.justsoftware.justimport.persistence.model.DbProfile;
import de.justsoftware.justimport.persistence.model.DbScimUserResource;
import de.justsoftware.justimport.persistence.model.DbUserGroupMember;
import de.justsoftware.justimport.persistence.model.DbUserGroupMemberId;
import de.justsoftware.justimport.persistence.model.ImportMethod;
import java.time.Instant;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import org.apache.commons.collections4.CollectionUtils;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.orm.ObjectOptimisticLockingFailureException;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class ScimUsersService {
    private static final Logger LOG = LoggerFactory.getLogger(ScimUsersService.class);
    private final ProfileRepository _profileRepo;
    private final ScimUserResourceRepository _scimUserResourceRepository;
    private final UserGroupMemberRepository _groupMemberRepo;
    private final ToroApiService _toroApiService;
    private final UserGroupImportPublisher _userGroupPublisher;
    private final ScimFieldMappingService _scimFieldMappingService;

    @Autowired
    public ScimUsersService(ProfileRepository profileRepo, ScimUserResourceRepository scimUserResourceRepository, UserGroupMemberRepository groupMemberRepo, ToroApiService toroApiService, UserGroupImportPublisher userGroupPublisher, ScimFieldMappingService scimFieldMappingService) {
        this._profileRepo = profileRepo;
        this._scimUserResourceRepository = scimUserResourceRepository;
        this._groupMemberRepo = groupMemberRepo;
        this._toroApiService = toroApiService;
        this._userGroupPublisher = userGroupPublisher;
        this._scimFieldMappingService = scimFieldMappingService;
    }

    public List<ValidUserResource> find(SearchRequest searchRequest, AuthorizationContext authCtx) throws NotImplementedException, BadRequestException {
        TenantId tenantId = authCtx.tenantId();
        String filterValue = this.getFilterValue(searchRequest);
        if (filterValue == null) {
            return List.of();
        }
        Optional user = this._scimUserResourceRepository.byTenantIdAndUserName(tenantId, filterValue);
        if (user.isEmpty()) {
            return List.of();
        }
        return List.of(((DbScimUserResource)user.get()).getUserResource());
    }

    @Transactional
    public ValidUserResource create(ValidUserResource user, AuthorizationContext authCtx) throws ResourceConflictException, PreconditionFailedException, ServerErrorException {
        TenantId tenantId = authCtx.tenantId();
        Optional resourceByUserName = this._scimUserResourceRepository.byTenantIdAndUserName(tenantId, user.getUserName());
        if (resourceByUserName.isPresent()) {
            throw new ResourceConflictException("User with this email already exists");
        }
        Optional resourceByExternalId = this._scimUserResourceRepository.byTenantIdAndExternalId(tenantId, user.getExternalId());
        if (resourceByExternalId.isPresent()) {
            throw new ResourceConflictException("User with this external ID already exists");
        }
        LOG.debug("Attempting to create user in toro: {}", (Object)user);
        ToroProfile toroProfile = this._toroApiService.createProfile(user, tenantId);
        DbProfile dbProfile = DbProfile.toDbProfile((ToroProfile)toroProfile);
        UUID profileUid = dbProfile.getUuid();
        user.setId(profileUid.toString());
        this._profileRepo.save((Object)dbProfile);
        DbScimUserResource persistedResource = this._scimUserResourceRepository.findByProfileIdAndTenantId(profileUid, (UUID)tenantId.getId()).map(existing -> {
            existing.setUserResource(user);
            return existing;
        }).orElseGet(() -> (DbScimUserResource)this._scimUserResourceRepository.save((Object)new DbScimUserResource(profileUid, tenantId, user)));
        List memberships = ScimUsersService.getGroupsMemberships((UUID)profileUid, (ValidUserResource)user);
        if (memberships != null) {
            this._groupMemberRepo.saveAll((Iterable)memberships);
        }
        this._scimFieldMappingService.importProfileAttributes(persistedResource);
        return persistedResource.getUserResource();
    }

    public ValidUserResource byId(UUID profileUid, AuthorizationContext authCtx) throws ResourceNotFoundException {
        TenantId tenantId = authCtx.tenantId();
        this._profileRepo.findByTenantIdAndUuid(tenantId, profileUid).orElseThrow(() -> ScimUsersService.userNotFound((UUID)profileUid));
        return ((DbScimUserResource)this._scimUserResourceRepository.byTenantIdAndProfileId(tenantId, profileUid).orElseThrow(() -> ScimUsersService.userNotFound((UUID)profileUid))).getUserResource();
    }

    @Transactional
    public ValidUserResource patch(UUID profileUid, PatchRequest patch, AuthorizationContext authCtx) throws ScimException, JsonProcessingException {
        TenantId tenantId = authCtx.tenantId();
        DbScimUserResource dbResource = this._scimUserResourceRepository.byTenantIdAndProfileId(tenantId, profileUid).orElse(null);
        DbProfile profile = this._profileRepo.findByTenantIdAndUuid(tenantId, profileUid).orElse(null);
        if (dbResource == null || profile == null) {
            throw ScimUsersService.userNotFound((UUID)profileUid);
        }
        ValidUserResource patchedResource = ValidUserResource.patch((ValidUserResource)dbResource.getUserResource(), (PatchRequest)patch);
        dbResource.setUserResource(patchedResource);
        DbScimUserResource persistedPatchedResource = (DbScimUserResource)this._scimUserResourceRepository.save((Object)dbResource);
        ToroProfile toroProfile = this._toroApiService.replaceProfile(profile.getProfileId(), patchedResource, tenantId);
        DbProfile persistedProfile = (DbProfile)this._profileRepo.save((Object)DbProfile.toDbProfile((ToroProfile)toroProfile));
        List originalMemberships = this._groupMemberRepo.findAllById_ProfileId(persistedProfile.getUuid());
        List patchedMemberships = ScimUsersService.getGroupsMemberships((UUID)persistedProfile.getUuid(), (ValidUserResource)patchedResource);
        this.patchAndPublishMemberships(persistedProfile.getProfileId(), (Collection)originalMemberships, (Collection)patchedMemberships);
        this._scimFieldMappingService.importProfileAttributes(persistedPatchedResource);
        return persistedPatchedResource.getUserResource();
    }

    @Transactional
    public ValidUserResource replace(UUID profileUid, ValidUserResource user, AuthorizationContext authCtx) throws ResourceNotFoundException, PreconditionFailedException {
        TenantId tenantId = authCtx.tenantId();
        this._scimUserResourceRepository.byTenantIdAndProfileId(tenantId, profileUid).orElseThrow(() -> ScimUsersService.userNotFound((UUID)profileUid));
        DbProfile foundProfile = (DbProfile)this._profileRepo.findByTenantIdAndUuid(tenantId, profileUid).orElseThrow(() -> ScimUsersService.userNotFound((UUID)profileUid));
        DbProfile dbProfile = DbProfile.toDbProfile((Long)foundProfile.getId(), (UUID)profileUid, (ValidUserResource)user, (TenantId)tenantId);
        List originalMemberships = this._groupMemberRepo.findAllById_ProfileId(profileUid);
        List updatedMemberships = ScimUsersService.getGroupsMemberships((UUID)profileUid, (ValidUserResource)user);
        DbProfile persistedProfile = (DbProfile)this._profileRepo.save((Object)dbProfile);
        user.setId(profileUid.toString());
        DbScimUserResource dbResource = new DbScimUserResource(profileUid, tenantId, user);
        this._scimUserResourceRepository.save((Object)dbResource);
        this.patchAndPublishMemberships(persistedProfile.getProfileId(), (Collection)originalMemberships, (Collection)updatedMemberships);
        this._toroApiService.replaceProfile(persistedProfile.getProfileId(), dbResource.getUserResource(), tenantId);
        this._scimFieldMappingService.importProfileAttributes(dbResource);
        return dbResource.getUserResource();
    }

    @Transactional
    public void delete(UUID profileUid, AuthorizationContext authCtx) throws ResourceNotFoundException {
        TenantId tenantId = authCtx.tenantId();
        DbProfile profile = (DbProfile)this._profileRepo.findByTenantIdAndUuid(tenantId, profileUid).orElseThrow(() -> ScimUsersService.userNotFound((UUID)profileUid));
        this._scimUserResourceRepository.byTenantIdAndProfileId(tenantId, profileUid).orElseThrow(() -> ScimUsersService.userNotFound((UUID)profileUid));
        List<UserGroupId> groupIdsMemberWasRemovedFrom = this._groupMemberRepo.deleteAllById_ProfileId(profileUid).stream().map(it -> new UserGroupId(it.getUserGroupId())).toList();
        try {
            this._profileRepo.deleteByTenantIdAndUuid(tenantId, profileUid);
        }
        catch (ObjectOptimisticLockingFailureException e) {
            LOG.warn("Trying to delete profile with id {}, but was already deleted. Ignoring.", (Object)profileUid);
        }
        ProfileId profileId = ProfileId.fromLongId((Long)profile.getId());
        this._toroApiService.deleteProfile(profileId, tenantId);
        this._userGroupPublisher.publishRemovedUserGroupMembers(groupIdsMemberWasRemovedFrom, profileId);
    }

    private void patchAndPublishMemberships(ProfileId profileId, Collection<DbUserGroupMember> originalMemberships, @Nullable Collection<DbUserGroupMember> updatedMemberships) {
        if (updatedMemberships == null) {
            return;
        }
        List<DbUserGroupMemberId> removedMemberships = CollectionUtils.removeAll(originalMemberships, updatedMemberships).stream().map(DbUserGroupMember::getId).toList();
        Collection addedMemberships = CollectionUtils.removeAll(updatedMemberships, originalMemberships);
        this._groupMemberRepo.deleteAllById(removedMemberships);
        this._groupMemberRepo.saveAll((Iterable)addedMemberships);
        this.publishRemovedUserGroupMemberships(profileId, removedMemberships);
        this.publishAddedUserGroupMemberships(profileId, addedMemberships);
    }

    private @Nullable String getFilterValue(SearchRequest searchRequest) throws NotImplementedException, BadRequestException {
        String stringFilter = searchRequest.getFilter();
        if (stringFilter == null || stringFilter.isEmpty()) {
            return null;
        }
        String filterValue = null;
        Filter filter = Filter.fromString((String)stringFilter);
        if (filter != null && filter.getFilterType() == FilterType.EQUAL) {
            ValueNode comparisonValue = filter.getComparisonValue();
            if (comparisonValue == null || comparisonValue.textValue().isEmpty()) {
                throw new NotImplementedException("Only equals filter supported");
            }
            filterValue = comparisonValue.textValue();
        }
        return filterValue;
    }

    private static @Nullable List<DbUserGroupMember> getGroupsMemberships(UUID profileUid, ValidUserResource user) {
        List groups = user.asUserResource().getGroups();
        return groups == null ? null : groups.stream().map(group -> new DbUserGroupMember(new DbUserGroupMemberId(profileUid, UUID.fromString(group.getValue())), Instant.now(), ImportMethod.SCIM)).toList();
    }

    private static ResourceNotFoundException userNotFound(UUID id) {
        return new ResourceNotFoundException(String.format("User with id %s not found", id));
    }

    private void publishAddedUserGroupMemberships(ProfileId profileId, Collection<DbUserGroupMember> addedMemberships) {
        this._userGroupPublisher.publishAddedUserGroupMembers(addedMemberships.stream().map(member -> new UserGroupId(member.getUserGroupId())).toList(), profileId);
    }

    private void publishRemovedUserGroupMemberships(ProfileId profileId, List<DbUserGroupMemberId> removedMemberships) {
        this._userGroupPublisher.publishRemovedUserGroupMembers(removedMemberships.stream().map(memberId -> new UserGroupId(memberId.getUserGroupId())).toList(), profileId);
    }
}

