/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.justimport.business.model;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.node.TextNode;
import com.unboundid.scim2.common.Path;
import com.unboundid.scim2.common.exceptions.PreconditionFailedException;
import com.unboundid.scim2.common.exceptions.ScimException;
import com.unboundid.scim2.common.messages.PatchRequest;
import com.unboundid.scim2.common.types.Name;
import com.unboundid.scim2.common.types.UserResource;
import com.unboundid.scim2.common.utils.JsonUtils;
import de.justsoftware.justimport.business.model.ValidUserResource;
import de.justsoftware.justimport.util.PatchRequestUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.jspecify.annotations.Nullable;

/*
 * Exception performing whole class analysis ignored.
 */
public final class ValidUserResource {
    public static final String MANAGER_PATH = "urn:ietf:params:scim:schemas:extension:enterprise:2.0:User:manager";
    private final UserResource _user;

    private ValidUserResource(UserResource user) {
        this._user = user;
    }

    public static ValidUserResource of(UserResource user) throws PreconditionFailedException {
        ValidUserResource.validate((UserResource)user);
        UserResource normalized = ValidUserResource.normalizeManagerValues((UserResource)user);
        return new ValidUserResource(normalized);
    }

    public static void validate(UserResource user) throws PreconditionFailedException {
        Name name;
        ArrayList<String> missingAttributes = new ArrayList<String>();
        if (user.getUserName() == null) {
            missingAttributes.add("userName");
        }
        if (user.getExternalId() == null) {
            missingAttributes.add("externalId");
        }
        if ((name = user.getName()) == null) {
            missingAttributes.add("name");
        } else {
            if (name.getGivenName() == null) {
                missingAttributes.add("name.givenName");
            }
            if (name.getFamilyName() == null) {
                missingAttributes.add("name.familyName");
            }
        }
        if (!missingAttributes.isEmpty()) {
            throw new PreconditionFailedException("Missing required attributes: " + String.join((CharSequence)", ", missingAttributes));
        }
    }

    public static ValidUserResource patch(ValidUserResource user, PatchRequest request) throws ScimException, JsonProcessingException {
        UserResource fixedUser = PatchRequestUtils.patchUser((UserResource)user.asUserResource(), (PatchRequest)request);
        return ValidUserResource.of((UserResource)fixedUser);
    }

    private static UserResource normalizeManagerValues(UserResource inputUser) throws PreconditionFailedException {
        try {
            UserResource user = ValidUserResource.deepCopy((UserResource)inputUser);
            List managerValues = user.getExtensionValues(Path.fromString((String)"urn:ietf:params:scim:schemas:extension:enterprise:2.0:User:manager"));
            if (managerValues.size() == 1 && managerValues.get(0) instanceof TextNode) {
                user.removeExtensionValues(Path.fromString((String)"urn:ietf:params:scim:schemas:extension:enterprise:2.0:User:manager"));
            }
            return user;
        }
        catch (ScimException e) {
            throw new PreconditionFailedException("Could not normalize manager values on given user resource", (Throwable)e);
        }
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public String getUserName() {
        return this._user.getUserName();
    }

    public Name getName() {
        return this._user.getName();
    }

    public String getExternalId() {
        return this._user.getExternalId();
    }

    public String getGivenName() {
        return this.getName().getGivenName();
    }

    public String getFamilyName() {
        return this.getName().getFamilyName();
    }

    public @Nullable String getHonorificPrefix() {
        return this.getName().getHonorificPrefix();
    }

    public @Nullable String getHonorificSuffix() {
        return this.getName().getHonorificSuffix();
    }

    public void setId(String id) {
        this.asUserResource().setId(id);
    }

    public boolean getActive() {
        return ValidUserResource.toPrimitiveBool((Boolean)this._user.getActive());
    }

    public UserResource asUserResource() {
        return this._user;
    }

    private static boolean toPrimitiveBool(@Nullable Boolean bool) {
        return Boolean.TRUE.equals(bool);
    }

    private static UserResource deepCopy(UserResource original) {
        try {
            String jsonNode = JsonUtils.getObjectWriter().writeValueAsString((Object)original);
            return (UserResource)JsonUtils.getObjectReader().forType(UserResource.class).readValue(jsonNode);
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to create deep copy of UserResource", e);
        }
    }
}

