/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.justimport.business;

import de.justsoftware.justimport.business.model.ToroProfile;
import de.justsoftware.justimport.business.model.ToroUserParams;
import de.justsoftware.justimport.business.model.ValidUserResource;
import de.justsoftware.justimport.domain.model.common.TenantId;
import de.justsoftware.justimport.domain.model.profile.ProfileId;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import org.jspecify.annotations.Nullable;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.web.client.RestClient;
import org.springframework.web.util.UriComponentsBuilder;

@Service
public class ToroApiService {
    private final RestClient _restClient;
    private final String _toroUrl;

    @Autowired
    public ToroApiService(@Value(value="${just.toro.internal.baseurl}") String toroUrl, RestClient.Builder restClientBuilder) {
        this._toroUrl = toroUrl;
        this._restClient = restClientBuilder.baseUrl(toroUrl).build();
    }

    public ToroProfile createProfile(ValidUserResource user, TenantId tenantId) {
        return Objects.requireNonNull((ToroProfile)((RestClient.RequestBodySpec)this._restClient.post().uri(this.getScimUsersUri(tenantId))).body((Object)ToroUserParams.fromUserResource((ValidUserResource)user)).retrieve().body(ToroProfile.class), "Toro did not return a profile");
    }

    public ToroProfile replaceProfile(ProfileId id, ValidUserResource user, TenantId tenantId) {
        return Objects.requireNonNull((ToroProfile)((RestClient.RequestBodySpec)this._restClient.put().uri(this.getScimUsersUri(id, tenantId))).body((Object)ToroUserParams.fromUserResource((ValidUserResource)user)).retrieve().body(ToroProfile.class), "Toro did not return a profile");
    }

    public void deleteProfile(ProfileId id, TenantId tenantId) {
        this._restClient.delete().uri(this.getScimUsersUri(id, tenantId)).retrieve().toBodilessEntity();
    }

    private URI getScimUsersUri(TenantId tenantId) {
        return this.getScimUsersUri(null, tenantId);
    }

    private URI getScimUsersUri(@Nullable ProfileId id, TenantId tenantId) {
        UriComponentsBuilder builder = UriComponentsBuilder.fromUriString((String)(this._toroUrl + "/internal/profile/scim/users"));
        if (id != null) {
            builder.pathSegment(new String[]{id.toString()});
        }
        return builder.queryParam("tenantId", new Object[]{tenantId.toString()}).encode(StandardCharsets.UTF_8).build().toUri();
    }
}

