/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.gateway.stats;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import de.justsoftware.gateway.security.JustAuthToken;
import de.justsoftware.gateway.stats.UserStatsService;
import de.justsoftware.jwtfilter.JwtAuthenticationToken;
import java.time.Duration;
import org.jspecify.annotations.Nullable;
import org.springframework.kafka.core.reactive.ReactiveKafkaProducerTemplate;
import org.springframework.security.core.Authentication;
import org.springframework.stereotype.Service;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class UserStatsService {
    private final Cache<String, UserActivity> _userStatsCache = Caffeine.newBuilder().expireAfterWrite(Duration.ofHours(1L)).build();
    private final ReactiveKafkaProducerTemplate<String, UserActivity> _reactiveKafkaProducerTemplate;

    public UserStatsService(ReactiveKafkaProducerTemplate<String, UserActivity> reactiveKafkaProducerTemplate) {
        this._reactiveKafkaProducerTemplate = reactiveKafkaProducerTemplate;
    }

    private void trackAccess(// Could not load outer class - annotation placement on inner may be incorrect
    @Nullable UserStatsService.UserActivity userActivity) {
        if (userActivity != null && this._userStatsCache.getIfPresent((Object)userActivity.cacheKey()) == null) {
            this._reactiveKafkaProducerTemplate.send("just.stats.userStats", (Object)userActivity).subscribe();
            this._userStatsCache.put((Object)userActivity.cacheKey(), (Object)userActivity);
        }
    }

    public void trackLogin(Authentication authentication) {
        if (authentication instanceof JustAuthToken) {
            JustAuthToken token = (JustAuthToken)authentication;
            this._reactiveKafkaProducerTemplate.send("just.stats.userStats", (Object)UserActivity.forLogin((JustAuthToken)token)).subscribe();
        }
    }

    public void trackAccess(Authentication authentication, UserActivityType type) {
        if (authentication instanceof JustAuthToken) {
            JustAuthToken token = (JustAuthToken)authentication;
            this.trackAccess(UserActivity.forAccess((JustAuthToken)token, (UserActivityType)type));
        }
        if (authentication instanceof JwtAuthenticationToken) {
            JwtAuthenticationToken jwt = (JwtAuthenticationToken)authentication;
            this.trackAccess(UserActivity.forAccess((JwtAuthenticationToken)jwt, (UserActivityType)type));
        }
    }
}

