/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.gateway.security;

import de.justsoftware.gateway.security.AuthenticationToJwtStringConverter;
import de.justsoftware.gateway.security.CookieUtil;
import de.justsoftware.gateway.security.JustAuthToken;
import de.justsoftware.gateway.security.JustAuthenticationManager;
import java.util.Objects;
import org.springframework.security.core.Authentication;
import org.springframework.security.web.server.WebFilterExchange;
import org.springframework.security.web.server.authentication.ServerAuthenticationSuccessHandler;
import org.springframework.stereotype.Service;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

@Service
public class LoginCookieHandler
implements ServerAuthenticationSuccessHandler {
    private final JustAuthenticationManager _manager;
    private final AuthenticationToJwtStringConverter _converter;

    public LoginCookieHandler(JustAuthenticationManager manager, AuthenticationToJwtStringConverter converter) {
        this._manager = manager;
        this._converter = converter;
    }

    public Mono<Void> onAuthenticationSuccess(WebFilterExchange webFilterExchange, Authentication originalAuthentication) {
        Mono convertedAuthentation = this._manager.authenticate(originalAuthentication);
        return convertedAuthentation.filter(auth -> auth instanceof JustAuthToken).cast(JustAuthToken.class).map(arg_0 -> ((AuthenticationToJwtStringConverter)this._converter).convert(arg_0)).filter(Objects::nonNull).flatMap(jwt -> {
            CookieUtil.addJustIdCookie((ServerWebExchange)webFilterExchange.getExchange(), (String)jwt);
            return Mono.empty();
        });
    }

    public static ServerWebExchange removeJustLoginCookies(ServerWebExchange exchange) {
        return CookieUtil.removeJustLoginCookies((ServerWebExchange)exchange);
    }
}

