/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.gateway.security;

import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import de.justsoftware.gateway.ids.ProfileId;
import de.justsoftware.gateway.security.AuthenticationToJwtStringConverter;
import de.justsoftware.gateway.security.JustAuthToken;
import de.justsoftware.gateway.security.JustJwtProperties;
import de.justsoftware.gateway.security.PrincipalId;
import de.justsoftware.jwtfilter.JwtClaimsHolder;
import de.justsoftware.jwtfilter.generator.JwtClaimsBuilder;
import de.justsoftware.jwtfilter.generator.JwtGenerator;
import de.justsoftware.jwtfilter.keys.JwtKeyLoadingException;
import java.time.Duration;
import java.util.Map;
import org.jose4j.lang.JoseException;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.convert.converter.Converter;
import org.springframework.stereotype.Service;

@Service
public final class AuthenticationToJwtStringConverter
implements Converter<JustAuthToken, String> {
    public static final String LOGIN_ID = "login_id";
    public static final String LOGIN_CLIENT_ID = "login_client_id";
    private static final Logger LOG = LoggerFactory.getLogger(AuthenticationToJwtStringConverter.class);
    private static final String TENANT_ID_KEY = "tenantId";
    private static final String SCOPE = "scope";
    private static final String PROFILE_ID = "profileId";
    private final long _tokenLifetime;
    private final JwtGenerator _jwtGenerator;
    private final LoadingCache<JwtCacheKey, String> _jwtCache;

    public AuthenticationToJwtStringConverter(JwtGenerator jwtGenerator, JustJwtProperties jwtProperties) {
        this._jwtGenerator = jwtGenerator;
        this._jwtCache = Caffeine.newBuilder().expireAfterWrite(Duration.ofMinutes(10L)).refreshAfterWrite(Duration.ofMinutes(5L)).maximumSize(10000L).build(arg_0 -> this.generateJwt(arg_0));
        this._tokenLifetime = jwtProperties.getCookie().getCookieLifetime().toMinutes();
    }

    public String convert(JustAuthToken authentication) {
        return (String)this._jwtCache.get((Object)new JwtCacheKey(authentication));
    }

    private @Nullable String generateJwt(JwtCacheKey key) {
        try {
            PrincipalId principalId;
            JwtClaimsBuilder claimsBuilder = new JwtClaimsBuilder().withSubject(key._principalId.asSubjectId()).withLifetime(this._tokenLifetime);
            if (key._tenantId != null) {
                claimsBuilder.withCustomClaim(TENANT_ID_KEY, key._tenantId.asString());
            }
            if (key._userLoginId != null) {
                claimsBuilder.withCustomClaim(LOGIN_ID, key._userLoginId.toUUIDString());
            }
            if (key._scope != null) {
                claimsBuilder.withCustomClaim(SCOPE, key._scope);
            }
            if ((principalId = key._principalId) instanceof ProfileId) {
                ProfileId profileId = (ProfileId)principalId;
                claimsBuilder.withCustomClaim(PROFILE_ID, profileId.asString());
            }
            if (key._loginClientId != null) {
                claimsBuilder.withCustomClaim(LOGIN_CLIENT_ID, key._loginClientId);
            }
            return this._jwtGenerator.generateJWT(claimsBuilder);
        }
        catch (JwtKeyLoadingException | JoseException e) {
            LOG.error(e.getMessage(), e);
            return null;
        }
    }

    public String generateRefreshedJwt(JwtClaimsHolder authenticatingToken) throws IllegalStateException {
        JwtClaimsBuilder claimsBuilder = new JwtClaimsBuilder();
        try {
            String authenticatedId = this.extractNumericProfileId(authenticatingToken);
            claimsBuilder.withSubject(authenticatedId).withLifetime(this._tokenLifetime);
            for (Map.Entry claim : authenticatingToken.getCustomJwtClaims().entrySet()) {
                claimsBuilder.withCustomClaim((String)claim.getKey(), claim.getValue().toString());
            }
            return this._jwtGenerator.generateJWT(claimsBuilder);
        }
        catch (JwtKeyLoadingException | IndexOutOfBoundsException | JoseException e) {
            throw new IllegalStateException("Could not generate new token.", e);
        }
    }

    private String extractNumericProfileId(JwtClaimsHolder authenticatingToken) {
        return authenticatingToken.getSubject().split(",")[1];
    }
}

