/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.gateway.monitoring;

import de.justsoftware.gateway.monitoring.GatewayRouteHealthIndicator;
import de.justsoftware.gateway.monitoring.GatewayRouteHealthIndicatorConfiguration;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import org.springframework.boot.actuate.health.ReactiveHealthContributor;
import org.springframework.boot.actuate.health.ReactiveHealthContributorRegistry;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.context.event.ApplicationReadyEvent;
import org.springframework.boot.ssl.SslBundle;
import org.springframework.boot.ssl.SslBundles;
import org.springframework.cloud.gateway.route.Route;
import org.springframework.cloud.gateway.route.RouteLocator;
import org.springframework.context.ApplicationListener;
import org.springframework.context.annotation.Configuration;

@ConditionalOnWebApplication
@Configuration
public class GatewayRouteHealthIndicatorConfiguration
implements ApplicationListener<ApplicationReadyEvent> {
    private final RouteLocator _routeLocator;
    private final ReactiveHealthContributorRegistry _healthContributorRegistry;
    private final SslBundle _sslBundle;

    @SuppressFBWarnings(value={"CT_CONSTRUCTOR_THROW"}, justification="Fail-fast during Spring startup if required SSL bundle 'just' is missing")
    public GatewayRouteHealthIndicatorConfiguration(RouteLocator routeLocator, ReactiveHealthContributorRegistry healthContributorRegistry, SslBundles bundles) {
        this._routeLocator = routeLocator;
        this._healthContributorRegistry = healthContributorRegistry;
        this._sslBundle = bundles.getBundle("just");
    }

    public void onApplicationEvent(ApplicationReadyEvent event) {
        ReactiveHealthContributor existingContributor = (ReactiveHealthContributor)this._healthContributorRegistry.getContributor("routes");
        if (existingContributor != null) {
            return;
        }
        this._routeLocator.getRoutes().filter(arg_0 -> this.monitoringEnabled(arg_0)).map(route -> new GatewayRouteHealthIndicator(route, this._sslBundle)).collectList().doOnSuccess(indicators -> {
            RoutingCompositeReactiveHealthContributor routesContributor = new RoutingCompositeReactiveHealthContributor(indicators);
            this._healthContributorRegistry.registerContributor("routes", (Object)routesContributor);
        }).subscribe();
    }

    private boolean monitoringEnabled(Route route) {
        return Boolean.parseBoolean(route.getMetadata().getOrDefault("monitoring-enabled", "true").toString());
    }
}

