/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.drive.rest.models;

import com.google.common.collect.ImmutableSet;
import de.justsoftware.drive.common.document.model.DocumentListSortParams;
import de.justsoftware.drive.common.person.model.PersonId;
import de.justsoftware.drive.common.usergroup.model.UserGroupId;
import io.swagger.v3.oas.annotations.media.Schema;
import org.jspecify.annotations.Nullable;

public class StartupConfig {
    private final boolean _publicLinksEnabled;
    private final PersonId _currentUser;
    private final String _fileSyncDownloadPageURL;
    private final ImmutableSet<String> _newFileTypes;
    private final boolean _mayCreateShares;
    private final long _uploadMaxFileSize;
    private final @Nullable UserGroupId _allUsersGroupId;
    private final DocumentListSortParams _documentListSortParams;
    private final boolean _antiVirusEnabled;

    public StartupConfig(boolean publicLinksEnabled, PersonId currentUser, String fileSyncDownloadPageURL, ImmutableSet<String> newFileTypes, boolean mayCreateShares, long uploadMaxFileSize, @Nullable UserGroupId allUsersGroupId, DocumentListSortParams documentListSortParams, boolean antiVirusEnabled) {
        this._publicLinksEnabled = publicLinksEnabled;
        this._currentUser = currentUser;
        this._fileSyncDownloadPageURL = fileSyncDownloadPageURL;
        this._newFileTypes = newFileTypes;
        this._mayCreateShares = mayCreateShares;
        this._uploadMaxFileSize = uploadMaxFileSize;
        this._allUsersGroupId = allUsersGroupId;
        this._documentListSortParams = documentListSortParams;
        this._antiVirusEnabled = antiVirusEnabled;
    }

    @Schema(required=true)
    public boolean isPublicLinksEnabled() {
        return this._publicLinksEnabled;
    }

    @Schema(required=true)
    public PersonId getCurrentUser() {
        return this._currentUser;
    }

    @Schema(required=true)
    public String getFileSyncDownloadPageURL() {
        return this._fileSyncDownloadPageURL;
    }

    @Schema(required=false)
    public ImmutableSet<String> getNewFileTypes() {
        return this._newFileTypes;
    }

    @Schema(required=true)
    public boolean isMayCreateShares() {
        return this._mayCreateShares;
    }

    @Schema(required=true)
    public long getUploadMaxFileSize() {
        return this._uploadMaxFileSize;
    }

    @Schema(required=true)
    public @Nullable String getAllUsersGroupId() {
        if (this._allUsersGroupId == null) {
            return null;
        }
        return this._allUsersGroupId.asPermissionRole().asString();
    }

    public DocumentListSortParams getDocumentSortParams() {
        return this._documentListSortParams;
    }

    @Schema(required=true)
    public boolean isAntiVirusEnabled() {
        return this._antiVirusEnabled;
    }
}

