/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.drive.rest.models;

import de.justsoftware.drive.rest.models.DocumentListEntry;
import de.justsoftware.drive.rest.models.DocumentPath;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.List;
import org.jspecify.annotations.Nullable;

@Schema(description="A list of documents")
public class DocumentList {
    private final @Nullable DocumentPath _documentPath;
    private final List<DocumentListEntry> _documents;
    private final long _numberOfDocs;

    public DocumentList(@Nullable DocumentPath path, List<DocumentListEntry> documents, long totalSize) {
        this._documents = documents;
        this._numberOfDocs = totalSize;
        this._documentPath = path;
    }

    @Schema(description="The files and folders matching the given parameters", required=true)
    public List<DocumentListEntry> getDocuments() {
        return this._documents;
    }

    @Schema(description="Optional path to root folder of the document list.", required=false)
    public @Nullable DocumentPath getDocumentPath() {
        return this._documentPath;
    }

    @Schema(description="Number of documents available for the requested parameters.", required=true)
    public long getNumberOfDocs() {
        return this._numberOfDocs;
    }
}

