/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.drive.rest.internal.models;

import de.justsoftware.drive.business.document.util.FileMetaInfoUtil;
import de.justsoftware.drive.common.document.model.DocumentId;
import de.justsoftware.drive.common.document.model.DocumentVersionId;
import de.justsoftware.drive.common.file.model.FileVersionBO;
import de.justsoftware.drive.common.person.model.PersonId;
import java.time.Instant;

public class InternalFileModel {
    private final DocumentId _id;
    private final String _name;
    private final PersonId _ownerId;
    private final Instant _lastModified;
    private final DocumentVersionId _versionId;
    private final int _version;
    private final long _size;
    private final String _extension;
    private final String _mimeType;

    public InternalFileModel(FileVersionBO file) {
        this._id = file.getDocumentId();
        this._name = file.getName();
        this._ownerId = file.getOwner();
        this._lastModified = file.getChangeDate();
        this._versionId = file.getId();
        this._version = file.getVersion();
        this._size = file.getFileSize();
        this._extension = FileMetaInfoUtil.getFileExtension((String)file.getName(), (String)file.getMimeType());
        this._mimeType = file.getMimeType();
    }

    public InternalFileModel(DocumentId id, String name, PersonId ownerId, Instant lastModified, DocumentVersionId versionId, int version, long size, String extension, String mimetype) {
        this._id = id;
        this._name = name;
        this._ownerId = ownerId;
        this._lastModified = lastModified;
        this._versionId = versionId;
        this._version = version;
        this._size = size;
        this._extension = extension;
        this._mimeType = mimetype;
    }

    public DocumentId getId() {
        return this._id;
    }

    public DocumentVersionId getVersionId() {
        return this._versionId;
    }

    public String getName() {
        return this._name;
    }

    public PersonId getOwnerId() {
        return this._ownerId;
    }

    public Instant getLastModified() {
        return this._lastModified;
    }

    public int getVersion() {
        return this._version;
    }

    public long getSize() {
        return this._size;
    }

    public String getExtension() {
        return this._extension;
    }

    public String getMimeType() {
        return this._mimeType;
    }
}

