/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.drive.rest.internal.controllers;

import de.justsoftware.drive.business.authorization.AuthorizationContext;
import de.justsoftware.drive.business.document.DocumentService;
import de.justsoftware.drive.business.document.DocumentTreeModificationService;
import de.justsoftware.drive.business.exception.PermissionDeniedException;
import de.justsoftware.drive.business.file.FileService;
import de.justsoftware.drive.business.file.VirusScannerService;
import de.justsoftware.drive.business.settings.SettingsService;
import de.justsoftware.drive.common.document.model.DocumentVersionId;
import de.justsoftware.drive.common.file.model.FileVersionBO;
import de.justsoftware.drive.common.tenant.model.TenantId;
import de.justsoftware.drive.rest.internal.models.UpdateVirusScanStatusDto;
import de.justsoftware.drive.rest.mapping.VirusScanResultIssueDto;
import de.justsoftware.drive.rest.models.PaginationResponse;
import de.justsoftware.permission.client.model.Role;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/internal"}, produces={"application/json"})
@Schema(description="DriveInternal")
public class InternalAntivirusController {
    private final SettingsService _settingsService;
    private final VirusScannerService _virusScannerService;
    private final DocumentService _documentService;
    private final DocumentTreeModificationService _documentTreeModificationService;
    private final FileService _fileService;

    @Autowired
    public InternalAntivirusController(SettingsService settingsService, VirusScannerService virusScannerService, DocumentService documentService, DocumentTreeModificationService documentTreeModificationService, FileService fileService) {
        this._settingsService = settingsService;
        this._virusScannerService = virusScannerService;
        this._documentService = documentService;
        this._documentTreeModificationService = documentTreeModificationService;
        this._fileService = fileService;
    }

    @RequestMapping(path={"/antivirus/issues"}, method={RequestMethod.GET})
    public PaginationResponse<VirusScanResultIssueDto> getAntiVirusIssues(AuthorizationContext authContext, @RequestParam(name="offset", defaultValue="0", required=false) int offset, @RequestParam(name="limit", defaultValue="200", required=false) int limit) {
        authContext.checkTenantManager();
        TenantId tenantId = authContext.getNonnullTenantId();
        this.checkFeatureEnabled(tenantId);
        List<VirusScanResultIssueDto> allIssues = this._virusScannerService.getIssues(tenantId).stream().filter(v -> !this._documentService.isDeleted(v.documentId())).toList();
        List selectedIssues = allIssues.stream().skip(offset).limit(limit).toList();
        return new PaginationResponse(selectedIssues, offset, limit, allIssues.size());
    }

    @RequestMapping(path={"/antivirus/issues/{id}"}, method={RequestMethod.PATCH})
    public void updateVirusScanStatus(AuthorizationContext authContext, @PathVariable DocumentVersionId id, @RequestBody UpdateVirusScanStatusDto updateVirusScanStatusDto) {
        authContext.checkTenantManager();
        TenantId tenantId = authContext.getNonnullTenantId();
        this.checkFeatureEnabled(tenantId);
        this._virusScannerService.overrideVirusScanStatus(id, updateVirusScanStatusDto.status(), authContext.getPersonId());
    }

    @RequestMapping(path={"/antivirus/issues/{id}"}, method={RequestMethod.DELETE})
    public void deleteInfectedFile(AuthorizationContext authContext, @PathVariable DocumentVersionId id) {
        FileVersionBO fileBo = this._fileService.getSingleVersionById(id);
        if (fileBo == null) {
            throw new IllegalArgumentException("fileVersion not found");
        }
        TenantId tenantId = fileBo.getTenantId();
        if (tenantId == null) {
            throw new PermissionDeniedException("tenantId of file unknown. only owner can delete it.");
        }
        authContext.check(Role.manage((String)tenantId.asPermissionRole().asString()));
        this.checkFeatureEnabled(tenantId);
        if (!fileBo.getVirusScanStatus().requiresAttention()) {
            throw new PermissionDeniedException("file is not infected, or in error state");
        }
        this._documentTreeModificationService.deleteDocument(fileBo.getDocumentId(), authContext.getPersonId());
    }

    @RequestMapping(path={"/antivirus/issues/{id}/rescan"}, method={RequestMethod.POST})
    public void rescanIssue(@PathVariable DocumentVersionId id, AuthorizationContext authContext) {
        authContext.checkTenantManager();
        TenantId tenantId = authContext.getNonnullTenantId();
        this.checkFeatureEnabled(tenantId);
        this._virusScannerService.rescanFile(id, tenantId);
    }

    private void checkFeatureEnabled(TenantId tenantId) {
        if (!this._settingsService.isAntivirusEnabled(tenantId)) {
            throw new IllegalStateException("Antivirus is disabled");
        }
    }
}

