/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.drive.rest.document.impl;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.Predicates;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimaps;
import com.google.common.collect.SetMultimap;
import com.google.common.io.ByteSource;
import de.justsoftware.drive.business.authorization.AuthorizationContext;
import de.justsoftware.drive.business.authorization.AuthorizationKey;
import de.justsoftware.drive.business.authorization.AuthorizationResult;
import de.justsoftware.drive.business.document.DocumentService;
import de.justsoftware.drive.business.document.DocumentVersionCountService;
import de.justsoftware.drive.business.file.FilePreviewService;
import de.justsoftware.drive.business.file.FileService;
import de.justsoftware.drive.business.folder.FolderService;
import de.justsoftware.drive.business.item.ItemReadService;
import de.justsoftware.drive.business.publiclinks.PublicLinkService;
import de.justsoftware.drive.business.settings.SettingsService;
import de.justsoftware.drive.business.thumbor.ThumborService;
import de.justsoftware.drive.common.authorization.model.StaticAction;
import de.justsoftware.drive.common.document.model.DocumentId;
import de.justsoftware.drive.common.document.model.DocumentListBO;
import de.justsoftware.drive.common.document.model.DocumentVersionBO;
import de.justsoftware.drive.common.document.model.DocumentVersionId;
import de.justsoftware.drive.common.file.model.FileVersionBO;
import de.justsoftware.drive.common.folder.model.FolderVersionBO;
import de.justsoftware.drive.common.item.model.ItemBO;
import de.justsoftware.drive.common.item.model.ItemId;
import de.justsoftware.drive.common.model.AbstractId;
import de.justsoftware.drive.common.tenant.model.TenantId;
import de.justsoftware.drive.rest.document.DocumentFrontendService;
import de.justsoftware.drive.rest.document.impl.DocumentFrontendServiceImpl;
import de.justsoftware.drive.rest.exceptions.BadRequestException;
import de.justsoftware.drive.rest.exceptions.UnknownResourceException;
import de.justsoftware.drive.rest.exceptions.ZipException;
import de.justsoftware.drive.rest.file.FileLockFrontendService;
import de.justsoftware.drive.rest.models.DocumentList;
import de.justsoftware.drive.rest.models.DocumentPath;
import de.justsoftware.drive.rest.models.Item;
import de.justsoftware.drive.rest.person.PersonFrontendService;
import de.justsoftware.drive.rest.util.ContentDispositionUtil;
import de.justsoftware.drive.rest.util.ZipUtil;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveOutputStream;
import org.jspecify.annotations.Nullable;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.MimeType;
import org.springframework.util.MimeTypeUtils;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.servlet.support.ServletUriComponentsBuilder;
import org.springframework.web.util.UriComponentsBuilder;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class DocumentFrontendServiceImpl
implements DocumentFrontendService {
    private static final ImmutableSet<StaticAction> NEEDED_ACTIONS = ImmutableSet.of((Object)StaticAction.DOCUMENT_WRITE, (Object)StaticAction.DOCUMENT_DELETE);
    private static final int DEFAULT_VIDEO_COVER_HEIGHT = 625;
    private static final int DEFAULT_VIDEO_COVER_WIDTH = (int)Math.ceil(1111.111111111111);
    private final FilePreviewService _filePreviewService;
    private final PersonFrontendService _personFrontendService;
    private final FolderService _folderService;
    private final FileService _fileService;
    private final ItemReadService _itemReadService;
    private final FileLockFrontendService _fileLockFrontendService;
    private final PublicLinkService _publicLinkService;
    private final SettingsService _settingsService;
    private final DocumentVersionCountService _documentVersionCountService;
    private final DocumentService _documentService;

    @Autowired
    public DocumentFrontendServiceImpl(FilePreviewService filePreviewService, PersonFrontendService personFrontendService, FolderService folderService, FileService fileService, ItemReadService itemReadService, FileLockFrontendService fileLockFrontendService, PublicLinkService publicLinkService, SettingsService settingsService, DocumentVersionCountService documentVersionCountService, DocumentService documentService) {
        this._filePreviewService = filePreviewService;
        this._personFrontendService = personFrontendService;
        this._folderService = folderService;
        this._fileService = fileService;
        this._itemReadService = itemReadService;
        this._fileLockFrontendService = fileLockFrontendService;
        this._publicLinkService = publicLinkService;
        this._settingsService = settingsService;
        this._documentVersionCountService = documentVersionCountService;
        this._documentService = documentService;
    }

    public DocumentList convertDocumentList(DocumentListBO documentListBO, AuthorizationContext authCtx) {
        FluentIterable versions = FluentIterable.from((Iterable)documentListBO.getDocuments()).filter(DocumentVersionBO.class).append((Iterable)documentListBO.getPath());
        HashMap<DocumentVersionId, DocumentId> map = new HashMap<DocumentVersionId, DocumentId>();
        DocumentId parent = null;
        for (FolderVersionBO pathElement : documentListBO.getPath()) {
            map.put(pathElement.getId(), parent);
            parent = pathElement.getDocumentId();
        }
        CreateDocumentVisitorImpl createDocument = new CreateDocumentVisitorImpl(this, documentListBO.getPersons(), (Iterable)versions, authCtx, id -> map.containsKey(id) ? (DocumentId)map.get(id) : documentListBO.getParent().getDocumentId());
        Item rootItem = this.getItem(documentListBO.getParent().getItemId(), authCtx);
        DocumentPath path = new DocumentPath((List)FluentIterable.from((Iterable)documentListBO.getPath()).transform(createDocument.toFolder()).toList(), rootItem);
        return new DocumentList(path, (List)FluentIterable.from((Iterable)documentListBO.getDocuments()).transform((Function)createDocument).toList(), (long)documentListBO.getTotalSize());
    }

    public Item getItem(ItemId itemId, AuthorizationContext authCtx) {
        ItemBO root = this._itemReadService.findItem(itemId);
        if (root == null) {
            return new Item(itemId);
        }
        ImmutableSetMultimap allowedActions = authCtx.may((SetMultimap)ImmutableSetMultimap.of((Object)itemId, (Object)StaticAction.SHARE_MANAGE, (Object)itemId, (Object)StaticAction.DOCUMENT_READ, (Object)itemId, (Object)StaticAction.DOCUMENT_WRITE));
        return new Item(root.getId(), root.getName(), allowedActions.get((Object)itemId));
    }

    private static String createRelativeUrlToApiEndpoint(DocumentVersionId id, String apiEndpoint) {
        ServletUriComponentsBuilder uriBuilder = RequestContextHolder.getRequestAttributes() != null ? ServletUriComponentsBuilder.fromCurrentContextPath() : UriComponentsBuilder.fromPath((String)"/drive");
        uriBuilder.host(null).port(null).scheme(null);
        return uriBuilder.path("/api" + apiEndpoint).buildAndExpand(new Object[]{id}).toUriString();
    }

    private String createVideoCoverUrl(DocumentVersionId fileVersionId) {
        return DocumentFrontendServiceImpl.createRelativeUrlToApiEndpoint((DocumentVersionId)fileVersionId, (String)("/previews/previewImage/{fileVersionId}?width=" + DEFAULT_VIDEO_COVER_WIDTH + "&height=625"));
    }

    @VisibleForTesting
    public static String createDownloadUrl(DocumentVersionId fileVersionId) {
        return DocumentFrontendServiceImpl.createRelativeUrlToApiEndpoint((DocumentVersionId)fileVersionId, (String)"/documents/fileversion/{fileVersionId}/download");
    }

    @VisibleForTesting
    @Nullable String createEmbedUrl(FileVersionBO fileVersion) {
        DocumentVersionId fileVersionId = fileVersion.getId();
        MimeType mimeType = MimeTypeUtils.parseMimeType((String)fileVersion.getMimeType());
        return switch (mimeType.getType()) {
            case "audio", "video" -> DocumentFrontendServiceImpl.createRelativeUrlToApiEndpoint((DocumentVersionId)fileVersionId, (String)"/previews/embed/{id}");
            case "image" -> {
                if (!ThumborService.isMediaTypeSupported((String)fileVersion.getMimeType())) {
                    yield null;
                }
                yield DocumentFrontendServiceImpl.createRelativeUrlToApiEndpoint((DocumentVersionId)fileVersionId, (String)"/previews/previewImage/{fileVersionId}");
            }
            default -> null;
        };
    }

    @VisibleForTesting
    @Nullable String createEmbedImagePreviewUrl(FileVersionBO fileVersion) {
        DocumentVersionId fileVersionId = fileVersion.getId();
        MimeType mimeType = MimeTypeUtils.parseMimeType((String)fileVersion.getMimeType());
        return switch (mimeType.getType()) {
            case "video" -> this.createVideoCoverUrl(fileVersionId);
            case "image" -> {
                if (!ThumborService.isMediaTypeSupported((String)fileVersion.getMimeType())) {
                    yield null;
                }
                yield DocumentFrontendServiceImpl.createRelativeUrlToApiEndpoint((DocumentVersionId)fileVersionId, (String)"/previews/previewImage/{fileVersionId}");
            }
            default -> null;
        };
    }

    private Map<DocumentVersionId, DocumentId> getParentFolderIdsForVersions(ImmutableSet<DocumentVersionId> versionIds) {
        if (versionIds.isEmpty()) {
            return ImmutableMap.of();
        }
        ListMultimap pathIdMultiMapMap = Multimaps.transformValues((ListMultimap)this._folderService.getPathBOs(versionIds), (Function)DocumentVersionBO.GET_DOCUMENT_ID);
        return Maps.transformValues((Map)Multimaps.asMap((ListMultimap)pathIdMultiMapMap), Iterables::getLast);
    }

    public DocumentFrontendService.CreateDocumentVisitor documentCreator(Iterable<? extends DocumentVersionBO> versions, AuthorizationContext authCtx) {
        ImmutableMap persons = this._personFrontendService.getPersons((Set)FluentIterable.from(versions).transform(DocumentVersionBO.GET_OWNER).filter(Predicates.notNull()).toSet());
        ImmutableSet versionIds = FluentIterable.from(versions).transform(DocumentVersionBO::getId).toSet();
        Map parents = this.getParentFolderIdsForVersions(versionIds);
        return new CreateDocumentVisitorImpl(this, persons, versions, authCtx, Objects.requireNonNull(parents::get));
    }

    public DocumentFrontendService.CreateDocumentVisitor documentCreator(DocumentVersionBO version, AuthorizationContext authCtx, @Nullable DocumentId parent) {
        ImmutableList versions = ImmutableList.of((Object)version);
        ImmutableMap persons = this._personFrontendService.getPersons((Set)ImmutableSet.of((Object)version.getOwner()));
        return new CreateDocumentVisitorImpl(this, persons, (Iterable)versions, authCtx, Functions.constant((Object)parent));
    }

    public void checkRead(AuthorizationContext authCtx, DocumentVersionId documentVersionId) {
        DocumentId document = (DocumentId)this._documentService.getDocumentIdsOfVersions(Set.of(documentVersionId)).get((Object)documentVersionId);
        if (document == null) {
            throw new UnknownResourceException("No document id for document version '" + String.valueOf(documentVersionId) + "' found.");
        }
        this.checkRead(authCtx, (AbstractId)document);
        this.checkRead(authCtx, (AbstractId)documentVersionId);
    }

    public void checkRead(AuthorizationContext authCtx, @Nullable AbstractId<?> nullableId) {
        AbstractId id = (AbstractId)BadRequestException.checkNotNull(nullableId);
        this.checkReadWrite(authCtx, (Set)ImmutableSet.of(), (Set)ImmutableSet.of((Object)id));
    }

    private static void readAllowed(ImmutableMap<AuthorizationKey<AbstractId<?>>, AuthorizationResult> allowed, AuthorizationContext authCtx, AbstractId<?> id) {
        AuthorizationResult readPublicAllowed = (AuthorizationResult)allowed.getOrDefault((Object)authCtx.key(id, StaticAction.DOCUMENT_READ), (Object)AuthorizationResult.RESOURCE_NOT_FOUND);
        readPublicAllowed.throwExcpetion();
    }

    public void checkReadWrite(AuthorizationContext authCtx, Set<? extends AbstractId<?>> targets, Set<? extends AbstractId> srcs) {
        ImmutableSet.Builder authKeys = ImmutableSet.builder();
        for (AbstractId<?> abstractId : targets) {
            authKeys.add((Object)authCtx.key(abstractId, StaticAction.DOCUMENT_WRITE));
        }
        for (AbstractId<?> abstractId : srcs) {
            authKeys.add((Object)authCtx.key(abstractId, StaticAction.DOCUMENT_READ));
        }
        ImmutableMap allowed = authCtx.allowed((Set)authKeys.build());
        for (AbstractId<?> abstractId : targets) {
            ((AuthorizationResult)allowed.getOrDefault((Object)authCtx.key(abstractId, StaticAction.DOCUMENT_WRITE), (Object)AuthorizationResult.RESOURCE_NOT_FOUND)).throwExcpetion();
        }
        for (AbstractId abstractId : srcs) {
            DocumentFrontendServiceImpl.readAllowed((ImmutableMap)allowed, (AuthorizationContext)authCtx, (AbstractId)abstractId);
        }
    }

    public void downloadFolderAsZip(HttpServletResponse response, DocumentVersionId documentVersionId, FolderVersionBO folderVersionBO, TenantId tenantId) throws IOException {
        ItemBO item;
        ImmutableList folderContents = this._folderService.getFolderContents((Set)ImmutableSet.of((Object)documentVersionId)).get((Object)documentVersionId);
        response.setContentType("application/zip");
        String rootFolderName = !folderVersionBO.isRoot() ? folderVersionBO.getName() : ((item = this._itemReadService.findItem(folderVersionBO.getItemId())) != null ? item.getName() : folderVersionBO.getName());
        ContentDispositionUtil.setContentDispositionAttachment((arg_0, arg_1) -> ((HttpServletResponse)response).setHeader(arg_0, arg_1), (String)(rootFolderName.replaceAll("[<>\\\\/:?*\"|]", "_") + ".zip"));
        try (ZipArchiveOutputStream zaos = ZipUtil.getZipArchiveOutputStream((HttpServletResponse)response);){
            ImmutableSet documentsInZip = this.putFolderIntoZip(ZipUtil.sanitizeFilename((String)rootFolderName), folderContents, zaos, tenantId);
            this._documentVersionCountService.increment((Set)documentsInZip);
        }
    }

    private ImmutableSet<DocumentVersionId> putFolderIntoZip(String name, ImmutableList<DocumentVersionBO> folderContents, ZipArchiveOutputStream zos, TenantId tenantId) throws ZipException {
        ImmutableSet.Builder includedDocuments = ImmutableSet.builder();
        for (DocumentVersionBO entryBO : folderContents) {
            entryBO.accept((DocumentVersionBO.Visitor)new /* Unavailable Anonymous Inner Class!! */);
        }
        return includedDocuments.build();
    }

    private void addFileToZip(FileVersionBO file, String filePath, ZipArchiveOutputStream zos, TenantId tenantId) throws IOException {
        if (!this._settingsService.isAntivirusEnabled(tenantId) || file.getVirusScanStatus().isClean()) {
            ByteSource fileSource = this._fileService.getFileByteSource(file, tenantId);
            zos.putArchiveEntry(new ZipArchiveEntry(filePath));
            fileSource.copyTo((OutputStream)zos);
            zos.closeArchiveEntry();
        }
    }
}

