/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.drive.rest.controllers;

import com.google.common.base.Function;
import com.google.common.base.Strings;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import de.justsoftware.drive.business.authorization.AuthorizationContext;
import de.justsoftware.drive.business.authorization.PersonAuthorizationContext;
import de.justsoftware.drive.business.change.ChangeModificationService;
import de.justsoftware.drive.business.folder.CurrentVersionData;
import de.justsoftware.drive.business.folder.FolderService;
import de.justsoftware.drive.business.search.DocumentSearchResultBO;
import de.justsoftware.drive.business.search.DocumentSearchResultEntryBO;
import de.justsoftware.drive.business.search.DocumentSearchService;
import de.justsoftware.drive.business.search.DriveSearchParameters;
import de.justsoftware.drive.business.search.DriveSearchParamsBuilder;
import de.justsoftware.drive.business.search.SearchSortParams;
import de.justsoftware.drive.common.document.model.DocumentId;
import de.justsoftware.drive.common.folder.model.FolderVersionBO;
import de.justsoftware.drive.common.item.model.ItemType;
import de.justsoftware.drive.common.model.AbstractId;
import de.justsoftware.drive.common.model.SortDirection;
import de.justsoftware.drive.rest.document.DocumentFrontendService;
import de.justsoftware.drive.rest.models.DocumentList;
import de.justsoftware.drive.rest.models.DocumentPath;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.jspecify.annotations.Nullable;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/documents/search"}, produces={"application/json"})
@Schema(description="Documents Search")
public class DocumentSearchController {
    static final String API_MAPPING = "/api/documents/search";
    private final DocumentSearchService _documentSearchService;
    private final DocumentFrontendService _documentFrontendService;
    private final FolderService _folderService;

    @Autowired
    public DocumentSearchController(DocumentSearchService documentSearchService, DocumentFrontendService documentFrontendService, FolderService folderService, ChangeModificationService changeModificationService) {
        this._documentSearchService = documentSearchService;
        this._documentFrontendService = documentFrontendService;
        this._folderService = folderService;
    }

    @Operation(description="Search in drive documents")
    @RequestMapping(method={RequestMethod.GET})
    public DocumentList search(PersonAuthorizationContext authCtx, @Parameter(description="limit the search to contents and subfolder of the given folder") @RequestParam(value="folderId", required=false) @Nullable DocumentId folderId, @Parameter(description="text to search for") @RequestParam(value="query", required=false) @Nullable String query, @Parameter(description="return only documents which are located below a parent of the provided item type") @RequestParam(value="parentItemType", required=false) @Nullable ItemType parentItemType, @RequestParam(value="sortField", defaultValue="RELEVANCE") SearchSortParams.SearchSortField sortField, @RequestParam(value="direction", defaultValue="DESC") SortDirection direction, @RequestParam(value="offset", defaultValue="0") int offset, @RequestParam(value="limit", defaultValue="20") int limit) {
        DriveSearchParamsBuilder params = DriveSearchParameters.builder();
        if (!Strings.isNullOrEmpty((String)query)) {
            params.searchText(query);
        }
        if (folderId != null) {
            this._documentFrontendService.checkRead((AuthorizationContext)authCtx, (AbstractId)folderId);
        }
        if (folderId != null) {
            params.searchInFolder(folderId);
        }
        if (parentItemType != null) {
            params.parentItemType(parentItemType);
        }
        DocumentSearchResultBO documentSearchResultBO = this._documentSearchService.search(authCtx, params.sort(sortField, direction).paging(offset, limit).build());
        FluentIterable versions = FluentIterable.from((Iterable)documentSearchResultBO.getResultEntries()).transform(DocumentSearchResultEntryBO.TO_DOCUMENT_VERSION_BO);
        DocumentFrontendService.CreateDocumentVisitor creator = this._documentFrontendService.documentCreator((Iterable)versions, (AuthorizationContext)authCtx);
        DocumentPath path = this.getPath(authCtx, folderId, creator);
        return new DocumentList(path, (List)versions.transform((Function)creator).toList(), documentSearchResultBO.getNumberOfResults());
    }

    private @Nullable DocumentPath getPath(PersonAuthorizationContext authCtx, @Nullable DocumentId folderId, DocumentFrontendService.CreateDocumentVisitor creator) {
        if (folderId != null) {
            CurrentVersionData versionData = (CurrentVersionData)this._folderService.getCurrentVersionDataOfDocuments((Set)ImmutableSet.of((Object)folderId)).get((Object)folderId);
            if (versionData == null) {
                return null;
            }
            ImmutableMap pathBOs = this._folderService.getFolderVersionsByIds((Set)versionData.getPath());
            List folders = versionData.getPath().stream().filter(arg_0 -> ((ImmutableMap)pathBOs).containsKey(arg_0)).map(key -> Objects.requireNonNull((FolderVersionBO)pathBOs.get(key))).map(creator.toFolder()).collect(Collectors.toList());
            return new DocumentPath(folders, this._documentFrontendService.getItem(versionData.getNewestChange().getItemId(), (AuthorizationContext)authCtx));
        }
        return null;
    }
}

