/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.drive.rest.config;

import com.google.common.collect.ImmutableList;
import de.justsoftware.jwtfilter.JwtAuthenticationProcessingFilter;
import jakarta.servlet.Filter;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.security.config.Customizer;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configuration.EnableWebSecurity;
import org.springframework.security.config.annotation.web.configurers.AbstractHttpConfigurer;
import org.springframework.security.config.annotation.web.configurers.AuthorizeHttpRequestsConfigurer;
import org.springframework.security.config.http.SessionCreationPolicy;
import org.springframework.security.web.SecurityFilterChain;
import org.springframework.security.web.authentication.preauth.AbstractPreAuthenticatedProcessingFilter;
import org.springframework.security.web.servlet.util.matcher.PathPatternRequestMatcher;
import org.springframework.security.web.util.matcher.OrRequestMatcher;
import org.springframework.security.web.util.matcher.RequestMatcher;

@Configuration
@EnableWebSecurity
public class RestSecurityConfig {
    private static final String INTERNAL_API = "/internal/**";
    private static final String FILESYNC_API = "/sync/**";
    private static final String PUBLIC_LINK_API = "/s/**";
    private static final String UNAUTHENTICATED_API = "/api/unauthenticated/**";
    private static final ImmutableList<String> JWT_IGNORE_PATHS = ImmutableList.of((Object)"/sync/**", (Object)"/s/**", (Object)"/api/unauthenticated/**");
    private static final ImmutableList<String> ALLOW_COOKIE_ONLY_AUTH_PATHS = ImmutableList.of((Object)"/api/previews/**", (Object)"/api/documents/folder/*/zip", (Object)"/api/documents/fileversion/*/download", (Object)"/api/documents/*/download");
    private static final String[] SWAGGER_RESOURCES = new String[]{"/swagger/**", "/configuration/**", "/swagger-resources/**", "/swagger-ui/**", "/webjars/**", "/v3/api-docs/**"};
    private static final PathPatternRequestMatcher.Builder PATH_REQUEST_MATCHER = PathPatternRequestMatcher.withDefaults();
    private static final OrRequestMatcher JWT_IGNORE_PATH_MATCHER = new OrRequestMatcher(JWT_IGNORE_PATHS.stream().map(arg_0 -> ((PathPatternRequestMatcher.Builder)PATH_REQUEST_MATCHER).matcher(arg_0)).collect(Collectors.toUnmodifiableList()));
    private static final OrRequestMatcher ALLOW_COOKIE_ONLY_AUTH = new OrRequestMatcher(ALLOW_COOKIE_ONLY_AUTH_PATHS.stream().map(arg_0 -> ((PathPatternRequestMatcher.Builder)PATH_REQUEST_MATCHER).matcher(arg_0)).collect(Collectors.toUnmodifiableList()));
    private final JwtAuthenticationProcessingFilter _jwtAuthenticationProcessingFilter;

    @Autowired
    public RestSecurityConfig(JwtAuthenticationProcessingFilter jwtAuthenticationProcessingFilter) {
        this._jwtAuthenticationProcessingFilter = jwtAuthenticationProcessingFilter;
    }

    @Bean
    public SecurityFilterChain securityFilterChain(HttpSecurity http) throws Exception {
        this._jwtAuthenticationProcessingFilter.applyIgnoreFilterMatcher((RequestMatcher)JWT_IGNORE_PATH_MATCHER).applyAllowCookieOnlyVerificationMatcher((RequestMatcher)ALLOW_COOKIE_ONLY_AUTH);
        http.sessionManagement(session -> session.sessionCreationPolicy(SessionCreationPolicy.STATELESS)).exceptionHandling(Customizer.withDefaults()).anonymous(Customizer.withDefaults()).servletApi(Customizer.withDefaults()).headers(headers -> headers.cacheControl(Customizer.withDefaults())).authorizeHttpRequests(auth -> ((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)auth.requestMatchers(new String[]{INTERNAL_API, FILESYNC_API, PUBLIC_LINK_API, UNAUTHENTICATED_API})).permitAll().requestMatchers(SWAGGER_RESOURCES)).permitAll().anyRequest()).authenticated()).addFilterAfter((Filter)this._jwtAuthenticationProcessingFilter, AbstractPreAuthenticatedProcessingFilter.class).csrf(AbstractHttpConfigurer::disable);
        return (SecurityFilterChain)http.build();
    }
}

