/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.drive.rest.annotation;

import de.justsoftware.drive.business.file.VirusScanNotCompletedException;
import de.justsoftware.drive.rest.annotation.RetryOnVirusScan;
import jakarta.servlet.http.HttpServletRequest;
import java.io.IOException;
import java.util.Objects;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.io.ClassPathResource;
import org.springframework.http.CacheControl;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;

@Aspect
@Component
public class VirusScanRetryAspect {
    private static final Logger LOG = LoggerFactory.getLogger(VirusScanRetryAspect.class);
    byte @Nullable [] _cachedPlaceholderImage;
    private final HttpServletRequest _request;
    @Value(value="${virus-scan.retry.max-attempts:3}")
    private int _defaultMaxAttempts;
    @Value(value="${virus-scan.retry.wait-time-millis:2000}")
    private long _defaultWaitTimeMillis;

    public VirusScanRetryAspect(HttpServletRequest request) {
        this._request = request;
    }

    @Around(value="@annotation(retryOnVirusScan)")
    public Object retryOnVirusScanException(ProceedingJoinPoint joinPoint, RetryOnVirusScan retryOnVirusScan) throws Throwable {
        int maxAttempts = retryOnVirusScan.maxAttempts() > 0 ? retryOnVirusScan.maxAttempts() : this._defaultMaxAttempts;
        long waitTimeMillis = retryOnVirusScan.waitTimeMillis() > 0L ? retryOnVirusScan.waitTimeMillis() : this._defaultWaitTimeMillis;
        long delayBetweenAttempts = waitTimeMillis / (long)(maxAttempts - 1);
        VirusScanNotCompletedException lastException = null;
        for (int attempt = 1; attempt <= maxAttempts; ++attempt) {
            try {
                return joinPoint.proceed();
            }
            catch (VirusScanNotCompletedException e) {
                lastException = e;
                if (attempt < maxAttempts) {
                    LOG.debug("Virus scan not completed on attempt {}/{}. Retrying in {}ms...", new Object[]{attempt, maxAttempts, delayBetweenAttempts});
                    Thread.sleep(delayBetweenAttempts);
                    continue;
                }
                LOG.debug("Virus scan not completed after {} attempts. Throwing exception.", (Object)maxAttempts);
                continue;
            }
        }
        Objects.requireNonNull(lastException, "lastException must not be null");
        if (this.shouldReturnPlaceholder()) {
            return this.placeholderResponse(lastException);
        }
        throw lastException;
    }

    private boolean shouldReturnPlaceholder() {
        String paramValue = this._request.getParameter("vph");
        return "t".equals(paramValue) || "1".equals(paramValue) || "true".equals(paramValue);
    }

    private ResponseEntity<byte[]> placeholderResponse(VirusScanNotCompletedException originalException) {
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.IMAGE_JPEG);
        headers.setCacheControl(CacheControl.noStore());
        headers.set("X-Virus-Scan-Status", "pending");
        return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatusCode)HttpStatus.ACCEPTED).headers(headers)).body((Object)this.loadPlaceholderImage(originalException));
    }

    private byte[] loadPlaceholderImage(VirusScanNotCompletedException originalException) {
        if (this._cachedPlaceholderImage != null) {
            return this._cachedPlaceholderImage;
        }
        try {
            this._cachedPlaceholderImage = new ClassPathResource("static/virus-scan-placeholder.png").getInputStream().readAllBytes();
            return this._cachedPlaceholderImage;
        }
        catch (IOException e) {
            LOG.error("Failed to load placeholder image", (Throwable)e);
            throw originalException;
        }
    }
}

