/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.drive.persistence.sharepermission;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.ImmutableTable;
import com.google.common.collect.Table;
import de.justsoftware.drive.common.authorization.model.SharePrivilege;
import de.justsoftware.drive.common.item.model.ItemId;
import de.justsoftware.drive.common.tenant.model.TenantId;
import de.justsoftware.drive.common.util.ObjectUtil;
import de.justsoftware.drive.mybatis.DAOSupport;
import de.justsoftware.drive.persistence.sharepermission.SharePermissionBO;
import de.justsoftware.drive.persistence.sharepermission.SharePermissionDAO;
import de.justsoftware.drive.persistence.sharepermission.SharePermissionMapper;
import de.justsoftware.drive.persistence.transaction.TransactionSupport;
import de.justsoftware.permission.client.model.Role;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository
public class SharePermissionDAOImpl
implements SharePermissionDAO {
    private final DAOSupport _daoSupport;
    private final SharePermissionMapper _mapper;
    private final TransactionSupport _transactionSupport;

    @Autowired
    public SharePermissionDAOImpl(DAOSupport daoSupport, SharePermissionMapper mapper, TransactionSupport transactionSupport) {
        this._daoSupport = daoSupport;
        this._mapper = mapper;
        this._transactionSupport = transactionSupport;
    }

    public void setPermission(Table<ItemId, Role, SharePrivilege> sharePermissions) {
        for (Table.Cell cell : sharePermissions.cellSet()) {
            ItemId row = (ItemId)ObjectUtil.checkNotNull((Object)((ItemId)cell.getRowKey()));
            Role column = (Role)ObjectUtil.checkNotNull((Object)((Role)cell.getColumnKey()));
            SharePrivilege value = (SharePrivilege)ObjectUtil.checkNotNull((Object)((SharePrivilege)cell.getValue()));
            this._mapper.setPermission(row, column, value);
        }
    }

    public void deletePermissions(ItemId share) {
        this._mapper.deletePermissions(share);
    }

    public void deletePermissions(Role role) {
        this._mapper.deletePermissionsForRole(role);
    }

    public ImmutableTable<ItemId, Role, SharePrivilege> getPermissions(Set<ItemId> shares) {
        return this._daoSupport.partition(shares).asTable((arg_0, arg_1) -> ((SharePermissionMapper)this._mapper).getPermissions(arg_0, arg_1));
    }

    public ImmutableSetMultimap<Role, ItemId> getSharesAccessibleBy(Set<Role> roles) {
        return this._daoSupport.partition(roles).asSetMultimap((arg_0, arg_1) -> ((SharePermissionMapper)this._mapper).getSharesAccessibleBy(arg_0, arg_1));
    }

    public int forEach(Consumer<SharePermissionBO> consumer) {
        return this._daoSupport.forAll(consumer, arg_0 -> ((SharePermissionMapper)this._mapper).forEach(arg_0));
    }

    public void deleteShares(Set<ItemId> shareIds) {
        this._daoSupport.partition(shareIds).noResult(arg_0 -> ((SharePermissionMapper)this._mapper).deleteShares(arg_0));
    }

    public ImmutableSet<TenantId> getAllTenantRoles() {
        return (ImmutableSet)this._mapper.getAllTenantRoles().stream().map(TenantId::fromRole).filter(Objects::nonNull).collect(ImmutableSet.toImmutableSet());
    }

    public void migrateTenantRole(Role tenantRole, Role allUsersGroupRole) {
        this._transactionSupport.doInTransaction(() -> {
            this._mapper.migrateTenantRole(tenantRole, allUsersGroupRole);
            this._mapper.deleteAllTenantRoles(tenantRole);
        });
    }
}

