/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.drive.persistence.person;

import de.justsoftware.drive.common.person.model.PersonConfigBO;
import de.justsoftware.drive.common.person.model.PersonId;
import de.justsoftware.drive.persistence.person.PersonConfigDAO;
import de.justsoftware.drive.persistence.person.PersonConfigMapper;
import java.util.Objects;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PersonConfigDAOImpl
implements PersonConfigDAO {
    private final PersonConfigMapper _mapper;

    @Autowired
    public PersonConfigDAOImpl(PersonConfigMapper mapper) {
        this._mapper = mapper;
    }

    public PersonConfigBO getPersonConfig(PersonId person) {
        PersonConfigBO config = this._mapper.getPersonConfig(person);
        return Objects.requireNonNullElse(config, PersonConfigBO.DEFAULT);
    }

    public void savePersonConfig(PersonId person, PersonConfigBO config) {
        this._mapper.insert(person, config);
        this._mapper.update(person, config);
    }
}

