/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.drive.persistence.folder;

import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSetMultimap;
import de.justsoftware.drive.common.document.model.DocumentId;
import de.justsoftware.drive.common.document.model.DocumentVersionBO;
import de.justsoftware.drive.common.document.model.DocumentVersionId;
import de.justsoftware.drive.common.folder.model.FolderVersionBO;
import de.justsoftware.drive.common.item.model.ItemId;
import de.justsoftware.drive.mybatis.DAOSupport;
import de.justsoftware.drive.persistence.document.DocumentVersionCreateModel;
import de.justsoftware.drive.persistence.document.DocumentVersionMapper;
import de.justsoftware.drive.persistence.folder.FolderVersionCreateModel;
import de.justsoftware.drive.persistence.folder.FolderVersionDAO;
import de.justsoftware.drive.persistence.folder.FolderVersionMapper;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository
public class FolderVersionDAOImpl
implements FolderVersionDAO {
    private final FolderVersionMapper _folderVersionMapper;
    private final DocumentVersionMapper _documentVersionMapper;
    private final DAOSupport _daoSupport;

    @Autowired
    public FolderVersionDAOImpl(FolderVersionMapper folderVersionMapper, DocumentVersionMapper documentVersionMapper, DAOSupport daoSupport) {
        this._folderVersionMapper = folderVersionMapper;
        this._documentVersionMapper = documentVersionMapper;
        this._daoSupport = daoSupport;
    }

    public ImmutableMap<DocumentVersionId, FolderVersionBO> getFolderVersionsByIds(Set<DocumentVersionId> folderVersionIds) {
        return (ImmutableMap)this._daoSupport.partition(folderVersionIds).index(DocumentVersionBO::getId).asMap().query((arg_0, arg_1) -> ((FolderVersionMapper)this._folderVersionMapper).getFolderVersionsByIds(arg_0, arg_1));
    }

    public ImmutableSetMultimap<DocumentId, DocumentVersionId> getVersionsByDocumentIds(Set<DocumentId> ids) {
        return this._daoSupport.partition(ids).asSetMultimap((arg_0, arg_1) -> ((FolderVersionMapper)this._folderVersionMapper).getVersionsByDocumentIds(arg_0, arg_1));
    }

    public ImmutableListMultimap<DocumentVersionId, FolderVersionBO> getFolderVersionsByChangeIds(Set<DocumentVersionId> changeIds) {
        return (ImmutableListMultimap)this._daoSupport.partition(changeIds).index(DocumentVersionBO::getChangeId).asListMultimap().query((arg_0, arg_1) -> ((FolderVersionMapper)this._folderVersionMapper).getFolderVersionsByChangeIds(arg_0, arg_1));
    }

    public void deleteIntroducedByChanges(Set<DocumentVersionId> changeIds) {
        this._daoSupport.partition(changeIds).noResult(arg_0 -> ((FolderVersionMapper)this._folderVersionMapper).deleteIntroducedByChanges(arg_0));
    }

    public void deleteByIds(Set<DocumentVersionId> ids) {
        this._daoSupport.partition(ids).noResult(versionIds -> {
            this._folderVersionMapper.deleteByIds(versionIds);
            this._documentVersionMapper.deleteByIds(versionIds);
        });
    }

    public void deleteAllForItem(ItemId itemId) {
        this._folderVersionMapper.deleteAllForItem(itemId);
        this._documentVersionMapper.deleteAllVersionsForItem(itemId);
    }

    public FolderVersionCreateModel folderVersionCreateModel() {
        return new FolderVersionCreateModel();
    }

    public void insertFolderVersions(Iterable<FolderVersionCreateModel> models) {
        for (FolderVersionCreateModel model : models) {
            this._documentVersionMapper.insertDocumentVersion((DocumentVersionCreateModel)model);
            this._folderVersionMapper.insertFolderVersion(model);
        }
    }
}

