/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.drive.persistence.document;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import de.justsoftware.drive.common.document.model.DocumentId;
import de.justsoftware.drive.common.document.model.DocumentVersionId;
import de.justsoftware.drive.common.item.model.ItemId;
import java.util.Map;
import java.util.Set;

public interface DocumentVersionDAO {
    public ImmutableMap<DocumentVersionId, DocumentId> getDocumentIdsOfVersions(Set<DocumentVersionId> var1);

    public ImmutableSetMultimap<DocumentVersionId, DocumentVersionId> getNewDocumentsForChange(Set<DocumentVersionId> var1);

    public ImmutableSetMultimap<DocumentVersionId, DocumentVersionId> getPublishedDocumentsForChange(Set<DocumentVersionId> var1);

    public ImmutableMap<DocumentVersionId, DocumentVersionId> getFirstPublishedChangesForDocumentVersions(Set<DocumentVersionId> var1);

    public ImmutableMap<DocumentVersionId, DocumentVersionId> getFirstPublishedChangesForDocumentsVersionsRecursive(Set<DocumentVersionId> var1);

    public void setFirstPublishedChange(Map<DocumentVersionId, DocumentVersionId> var1);

    public void deletePublishedChange(Set<DocumentVersionId> var1);

    public ImmutableMap<DocumentId, ItemId> getItemIdsOfDocument(Set<DocumentId> var1);

    public ImmutableMap<DocumentVersionId, ItemId> getItemIdsOfDocumentVersions(Set<DocumentVersionId> var1);

    public void moveVersionsToTargetChange(Set<DocumentVersionId> var1, DocumentVersionId var2);

    public void moveOtherVersionsToTargetChange(Map<DocumentId, DocumentVersionId> var1, DocumentVersionId var2);

    public void deleteIntroducedByChanges(Set<DocumentVersionId> var1);

    public ImmutableSet<DocumentId> getDocumentsByChangeIds(Set<DocumentVersionId> var1);

    public Set<DocumentVersionId> getAllDocumentsForItem(ItemId var1);
}

