/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.drive.persistence.context;

import de.justsoftware.drive.mybatis.SupportedJdbcDriver;
import de.justsoftware.drive.mybatis.result.DAOSupportImpl;
import de.justsoftware.drive.mybatis.type.AbstractDriverSpecificTypeHandler;
import de.justsoftware.drive.persistence.DrivePersistenceScanMarker;
import de.justsoftware.drive.persistence.context.DrivePersistenceConfiguration;
import javax.sql.DataSource;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.session.SqlSessionFactoryBuilder;
import org.apache.ibatis.transaction.TransactionFactory;
import org.mybatis.spring.SqlSessionFactoryBean;
import org.mybatis.spring.annotation.MapperScan;
import org.mybatis.spring.transaction.SpringManagedTransactionFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.DependsOn;

@Configuration
@MapperScan(basePackageClasses={DrivePersistenceScanMarker.class}, annotationClass=Mapper.class, sqlSessionFactoryRef="sqlSessionFactory")
public class DrivePersistenceConfiguration {
    static final String SQL_SESSION_FACTORY = "sqlSessionFactory";

    @Bean
    public SupportedJdbcDriver supportedJdbcDriver(@Value(value="${spring.datasource.url}") String jdbcUrl) {
        return SupportedJdbcDriver.driverFromUrl((String)jdbcUrl);
    }

    @Bean
    public DAOSupportImpl daoSupport(SupportedJdbcDriver driver) {
        return new DAOSupportImpl(() -> driver);
    }

    @Bean(value={"sqlSessionFactory"})
    @DependsOn(value={"liquibase"})
    public SqlSessionFactoryBean sessionFactoryBean(DataSource source, SupportedJdbcDriver supportedJdbcDriver, @Value(value="${just.drive.jdbc.batchsize:100}") int batchSize) {
        AbstractDriverSpecificTypeHandler.setJdbcDriver((SupportedJdbcDriver)supportedJdbcDriver);
        SqlSessionFactoryBean sessionFactoryBean = new SqlSessionFactoryBean();
        sessionFactoryBean.setDataSource(source);
        sessionFactoryBean.setTypeHandlersPackage("de.justsoftware.drive.persistence,de.justsoftware.drive.persistence.mybatis.type.common");
        sessionFactoryBean.setTransactionFactory((TransactionFactory)new SpringManagedTransactionFactory());
        sessionFactoryBean.setSqlSessionFactoryBuilder((SqlSessionFactoryBuilder)new SqlSessionFactoryBuilderExtension(supportedJdbcDriver, batchSize));
        return sessionFactoryBean;
    }
}

