/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.drive.persistence.accessrequest;

import de.justsoftware.drive.common.accessrequest.model.AccessRequestBO;
import de.justsoftware.drive.common.item.model.ItemId;
import de.justsoftware.drive.common.person.model.PersonId;
import java.util.List;
import org.apache.ibatis.annotations.Arg;
import org.apache.ibatis.annotations.ConstructorArgs;
import org.apache.ibatis.annotations.Insert;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.ResultType;
import org.apache.ibatis.annotations.Select;
import org.apache.ibatis.annotations.Update;

@Mapper
public interface AccessRequestMapper {
    @Select(value={"SELECT person_id, share_id", "FROM pending_access_request", "WHERE share_id = #{shareId}"})
    @ConstructorArgs(value={@Arg(column="person_id", javaType=PersonId.class), @Arg(column="share_id", javaType=ItemId.class)})
    @ResultType(value=AccessRequestBO.class)
    public List<AccessRequestBO> getPendingRequestsForShare(@Param(value="shareId") ItemId var1);

    @Select(value={"SELECT person_id, share_id", "FROM pending_access_request", "WHERE person_id = #{userId}"})
    @ConstructorArgs(value={@Arg(column="person_id", javaType=PersonId.class), @Arg(column="share_id", javaType=ItemId.class)})
    @ResultType(value=AccessRequestBO.class)
    public List<AccessRequestBO> getPendingRequestsForUser(@Param(value="userId") PersonId var1);

    @Update(value={"<script>", "DELETE FROM pending_access_request", "WHERE person_id = #{id}", "</script>"})
    public void deletePendingRequestsForUser(@Param(value="id") PersonId var1);

    @Update(value={"<script>", "DELETE FROM pending_access_request", "WHERE share_id = #{id}", "</script>"})
    public void deletePendingRequestsForShare(@Param(value="id") ItemId var1);

    @Update(value={"<script>", "DELETE FROM pending_access_request", "WHERE person_id IN (<foreach collection='userIds' item='userId' separator=','>#{userId}</foreach>) AND share_id = #{shareId}", "</script>"})
    public void deletePendingRequestByUserForShare(@Param(value="userIds") List<PersonId> var1, @Param(value="shareId") ItemId var2);

    @Insert(value={"<script>", "INSERT INTO pending_access_request(person_id, share_id)", "VALUES (#{userId}, #{shareId})", "</script>"})
    public void createNewPendingRequest(@Param(value="userId") PersonId var1, @Param(value="shareId") ItemId var2);
}

