/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.drive.mybatis.result;

import com.google.common.collect.Iterables;
import de.justsoftware.drive.mybatis.DAOSupport;
import de.justsoftware.drive.mybatis.SupportedJdbcDriver;
import de.justsoftware.drive.mybatis.result.ChunkedResultHandler;
import de.justsoftware.drive.mybatis.result.CountingResultHandler;
import de.justsoftware.drive.mybatis.result.DAOSupportImpl;
import de.justsoftware.drive.mybatis.result.InternalDAOSupport;
import de.justsoftware.drive.mybatis.result.NoResultQuery;
import de.justsoftware.drive.mybatis.result.ResultHandlerBuilder;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.apache.ibatis.session.ResultHandler;

public class DAOSupportImpl
implements DAOSupport,
InternalDAOSupport {
    private final Supplier<SupportedJdbcDriver> _jdbcDriverSupplier;

    public DAOSupportImpl(Supplier<SupportedJdbcDriver> jdbcDriverSupplier) {
        this._jdbcDriverSupplier = jdbcDriverSupplier;
    }

    public int defaultPartitionSize() {
        SupportedJdbcDriver driver = (SupportedJdbcDriver)this._jdbcDriverSupplier.get();
        switch (1.$SwitchMap$de$justsoftware$drive$mybatis$SupportedJdbcDriver[driver.ordinal()]) {
            case 1: {
                return 900;
            }
            case 2: {
                return 10000;
            }
        }
        throw new UnsupportedOperationException("no behavior for " + String.valueOf(driver) + " defined");
    }

    public <ID> ResultHandlerBuilder<ID> partition(Set<? extends ID> ids) {
        return new ResultHandlerBuilder((InternalDAOSupport)this, ids);
    }

    public <ID> void partition(Set<? extends ID> ids, NoResultQuery<ID> query) {
        for (List partition : Iterables.partition(ids, (int)this.defaultPartitionSize())) {
            query.query(Collections.unmodifiableList(partition));
        }
    }

    public <T> int forAllChunked(int chunkSize, Consumer<List<T>> consumer, Consumer<ResultHandler<T>> method) {
        return new ChunkedResultHandler(chunkSize, consumer).applyTo(method);
    }

    public <T> int forAll(Consumer<T> consumer, Consumer<ResultHandler<T>> method) {
        return new CountingResultHandler(consumer).applyTo(method);
    }
}

