/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.drive.mybatis;

public enum SupportedJdbcDriver {
    POSTGRES("org.postgresql.Driver"),
    ORACLE("oracle.jdbc.driver.OracleDriver");

    private final String _driverClassName;

    private SupportedJdbcDriver(String driverClassName) {
        this._driverClassName = driverClassName;
    }

    public static SupportedJdbcDriver driverFromUrl(String url) {
        if (url.startsWith("jdbc:postgresql:")) {
            return POSTGRES;
        }
        if (url.startsWith("jdbc:oracle")) {
            return ORACLE;
        }
        throw new UnsupportedOperationException("Don't know the driver for the url " + url);
    }

    public String getDriverClassName() {
        return this._driverClassName;
    }
}

