/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.drive.business.thumbor.impl;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.io.ByteSource;
import com.google.common.net.MediaType;
import de.justsoftware.drive.business.preview.CropStrategy;
import de.justsoftware.drive.business.preview.ImagePreviewOptions;
import de.justsoftware.drive.business.thumbor.ThumborHealthCheck;
import de.justsoftware.drive.business.thumbor.ThumborService;
import de.justsoftware.drive.business.thumbor.util.ThumborURLBuilder;
import de.justsoftware.drive.common.file.model.FilePreviewByteSource;
import io.micrometer.observation.annotation.Observed;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.RequestEntity;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.web.client.HttpServerErrorException;
import org.springframework.web.client.RestTemplate;

@Service
@Observed
public class ThumborServiceImpl
implements ThumborService {
    private static final Logger LOG = LoggerFactory.getLogger(ThumborServiceImpl.class);
    private final String _thumborHostname;
    private final int _thumborPort;
    private final ThumborHealthCheck _thumborHealthCheck;
    private final RestTemplate _restTemplate;

    @Autowired
    public ThumborServiceImpl(@Value(value="${just-thumbor.host:localhost}") String thumborHostname, @Value(value="${just-thumbor.port:8888}") int thumborPort, ThumborHealthCheck thumborHealthCheck, @Qualifier(value="driveFilePersistenceRestTemplate") RestTemplate restTemplate) {
        this._thumborHostname = thumborHostname;
        this._thumborPort = thumborPort;
        this._thumborHealthCheck = thumborHealthCheck;
        this._restTemplate = restTemplate;
    }

    private Optional<FilePreviewByteSource> thumborPreview(URL thumborUrl, ImagePreviewOptions options) {
        if (!this._thumborHealthCheck.isAvailable()) {
            return Optional.empty();
        }
        try {
            return this.getFilePreviewByteSource(thumborUrl, options);
        }
        catch (IOException iOException) {
        }
        catch (HttpServerErrorException.GatewayTimeout e) {
            LOG.info("A gateway timeout exception was thrown. This usually happens when Thumbor rejects large files (> 100MB). URL: {}", (Object)thumborUrl);
        }
        return Optional.empty();
    }

    public FilePreviewByteSource apply(MediaType originalMimeType, String fileStorageUrl, ImagePreviewOptions options) throws IOException {
        if (!ThumborService.isMediaTypeSupported((MediaType)originalMimeType)) {
            throw new UnsupportedOperationException("The given mime-type " + String.valueOf(originalMimeType) + " is not supported.");
        }
        URL thumborUrl = this.imagePreviewOptionsToUrl(originalMimeType, fileStorageUrl, options);
        return this.thumborPreview(thumborUrl, options).orElse(this.originalImage(fileStorageUrl, originalMimeType));
    }

    @VisibleForTesting
    URL imagePreviewOptionsToUrl(MediaType originalMimeType, String fileStorageUrl, ImagePreviewOptions options) {
        ThumborURLBuilder thumborUrlBuilder = new ThumborURLBuilder(this._thumborHostname, this._thumborPort, fileStorageUrl, originalMimeType.toString()).withHeight(options.getHeight()).withWidth(options.getWidth()).withSmart(true).withBlurFilter(options.getBlur()).convertGifToStaticImage(options.isStaticGif()).withFitIn(options.getCropStrategy() == CropStrategy.KEEP_ASPECT_RATIO);
        return thumborUrlBuilder.build();
    }

    @VisibleForTesting
    FilePreviewByteSource originalImage(String fileStorageUrl, MediaType originalMimeType) throws IOException {
        try {
            return FilePreviewByteSource.fromURL((URL)new URL(fileStorageUrl), (String)originalMimeType.toString());
        }
        catch (IOException e) {
            LOG.error("Could not load original image from Storage server. URL: " + fileStorageUrl, (Throwable)e);
            throw e;
        }
    }

    @VisibleForTesting
    Optional<FilePreviewByteSource> getFilePreviewByteSource(URL thumborServiceUrl, ImagePreviewOptions options) throws IOException {
        URI uri;
        try {
            uri = thumborServiceUrl.toURI();
        }
        catch (URISyntaxException e) {
            LOG.error("URL to Thumbor couldn't be parsed into an URI. URL: " + String.valueOf(thumborServiceUrl), (Throwable)e);
            return Optional.empty();
        }
        RequestEntity.HeadersBuilder request = RequestEntity.get((URI)uri);
        request.accept(options.getSupportedMediaTypes());
        ResponseEntity response = this._restTemplate.exchange(request.build(), byte[].class);
        org.springframework.http.MediaType contentTypeHeader = response.getHeaders().getContentType();
        if (contentTypeHeader == null) {
            LOG.error("Thumbor didn't reply with Content-Type header for URL: '{}'.", (Object)thumborServiceUrl);
            return Optional.empty();
        }
        byte[] body = (byte[])response.getBody();
        if (body == null) {
            LOG.error("Thumbor didn't respond with content for URL: '{}'.", (Object)thumborServiceUrl);
            return Optional.empty();
        }
        ByteSource byteSource = ByteSource.wrap((byte[])body);
        long size = response.getHeaders().getContentLength();
        if (size == -1L) {
            size = byteSource.size();
        }
        return Optional.of(new FilePreviewByteSource(size, contentTypeHeader.toString(), byteSource));
    }
}

