/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.drive.business.shares.impl;

import de.justsoftware.drive.business.shares.ShareRoleAssignmentPublisher;
import de.justsoftware.drive.common.authorization.model.SharePrivilege;
import de.justsoftware.drive.common.item.model.ItemId;
import de.justsoftware.drive.common.item.model.ItemType;
import de.justsoftware.drive.common.util.EntryStream;
import de.justsoftware.drive.persistence.sharepermission.SharePermissionDAO;
import de.justsoftware.permission.client.kafka.SingleRoleAssignmentProducer;
import de.justsoftware.permission.client.kafka.WaitForOffsets;
import de.justsoftware.permission.client.model.Role;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ShareRoleAssignmentPublisherImpl
implements ShareRoleAssignmentPublisher {
    private final SingleRoleAssignmentProducer _producer;
    private final SharePermissionDAO _sharePermissionDAO;

    @Autowired
    public ShareRoleAssignmentPublisherImpl(SingleRoleAssignmentProducer producer, SharePermissionDAO sharePermissionDAO) {
        this._producer = producer;
        this._sharePermissionDAO = sharePermissionDAO;
    }

    public WaitForOffsets publishSharePermission(ItemId shareId, Map<Role, Optional<SharePrivilege>> changedMembers) {
        return new WaitForOffsets(EntryStream.from(changedMembers).map((role, staticAction) -> this.publishSharePermission(shareId, role, staticAction)));
    }

    private WaitForOffsets publishSharePermission(ItemId shareId, Role role, Optional<SharePrivilege> privilege) {
        return new WaitForOffsets(Stream.of(SharePrivilege.values()).map(action -> {
            boolean addReplacement = privilege.map(arg_0 -> action.equals(arg_0)).orElse(false);
            if (addReplacement) {
                return this._producer.addRoleReplacement(Role.itemRole((String)action.name(), (String)((String)shareId.getId())), role);
            }
            return this._producer.deleteRoleReplacement(Role.itemRole((String)action.name(), (String)((String)shareId.getId())), role);
        }));
    }

    public void publishAllShareRoleAssignments() {
        this._producer.republishForAllItemRoles(ItemType.SHARE.name(), () -> this._sharePermissionDAO.forEach(permission -> {
            Role itemRole = Role.itemRole((String)permission.getPrivilege().name(), (String)((String)permission.getShareId().getId()));
            this._producer.addRoleReplacement(itemRole, permission.getRole());
        }));
    }
}

