/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.drive.business.kafka.impl;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import de.justsoftware.drive.business.judo.judoclient.conversiontask.ConversionTaskClient;
import de.justsoftware.drive.business.kafka.KafkaConfigurationProvider;
import de.justsoftware.drive.business.kafka.impl.KafkaConfiguration;
import de.justsoftware.drive.business.kafka.serde.ItemIdDeserializer;
import de.justsoftware.drive.common.item.model.ItemId;
import de.justsoftware.kafka.client.KafkaCleaningProducer;
import de.justsoftware.kafka.client.KafkaCleaningProducerImpl;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.kafka.clients.admin.NewTopic;
import org.apache.kafka.clients.producer.Producer;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.serialization.StringDeserializer;
import org.jspecify.annotations.Nullable;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.kafka.config.ConcurrentKafkaListenerContainerFactory;
import org.springframework.kafka.config.KafkaListenerContainerFactory;
import org.springframework.kafka.core.ConsumerFactory;
import org.springframework.kafka.core.DefaultKafkaConsumerFactory;
import org.springframework.kafka.core.KafkaAdmin;
import org.springframework.kafka.listener.CommonErrorHandler;
import org.springframework.kafka.listener.CommonLoggingErrorHandler;
import org.springframework.kafka.listener.ConcurrentMessageListenerContainer;
import org.springframework.kafka.listener.DefaultErrorHandler;
import org.springframework.kafka.support.serializer.ErrorHandlingDeserializer;

@Configuration
public class KafkaConfiguration {
    private static final String SEVEN_DAYS_IN_MS = "604800000";
    private static final ImmutableMap<String, String> DEFAULT_TOPIC_CONFIG = ImmutableMap.of((Object)"delete.retention.ms", (Object)"604800000", (Object)"segment.ms", (Object)"604800000", (Object)"cleanup.policy", (Object)"compact");

    @Bean(name={"KAFKA_STRING_PRODUCER"}, destroyMethod="close")
    public @Nullable KafkaCleaningProducer<String, String> createStringProducer(KafkaConfigurationProvider kafkaConfigurationProvider) {
        Properties producerConfig = kafkaConfigurationProvider.producerConfig();
        Properties consumerConfig = kafkaConfigurationProvider.consumerConfig(null);
        return producerConfig != null && consumerConfig != null ? new KafkaCleaningProducerImpl((Producer)new ClosingKafkaProducer(producerConfig), tp -> KafkaCleaningProducerImpl.createStringConsumer((TopicPartition)tp, (Properties)consumerConfig)) : null;
    }

    @Bean
    public ConversionTaskClient conversionTaskClient(KafkaCleaningProducer<String, String> kafkaProducer) {
        return new ConversionTaskClient(kafkaProducer);
    }

    @Bean
    public @Nullable KafkaAdmin admin(@Value(value="${just.drive.kafka.boostrapServers:}") @Nullable String bootstrapServer) {
        if (Strings.isNullOrEmpty((String)bootstrapServer)) {
            return null;
        }
        ImmutableMap configs = ImmutableMap.of((Object)"bootstrap.servers", (Object)bootstrapServer);
        KafkaAdmin kafkaAdmin = new KafkaAdmin((Map)configs);
        kafkaAdmin.setFatalIfBrokerNotAvailable(true);
        return kafkaAdmin;
    }

    private HashMap<String, Object> newConsumerFactoryPropsWithDefaults(String bootstrapServers) {
        HashMap<String, Object> props = new HashMap<String, Object>();
        props.put("bootstrap.servers", bootstrapServers);
        props.put("auto.offset.reset", "earliest");
        props.put("key.deserializer", ErrorHandlingDeserializer.class);
        props.put("value.deserializer", ErrorHandlingDeserializer.class);
        return props;
    }

    @Bean
    public KafkaListenerContainerFactory<ConcurrentMessageListenerContainer<ItemId, String>> itemIdStringConsumer(@Value(value="${just.drive.kafka.boostrapServers:}") String bootstrapServer) {
        HashMap props = this.newConsumerFactoryPropsWithDefaults(bootstrapServer);
        props.put("spring.deserializer.key.delegate.class", ItemIdDeserializer.class);
        props.put("spring.deserializer.value.delegate.class", StringDeserializer.class);
        ConcurrentKafkaListenerContainerFactory factory = new ConcurrentKafkaListenerContainerFactory();
        factory.setConsumerFactory((ConsumerFactory)new DefaultKafkaConsumerFactory((Map)props));
        factory.setCommonErrorHandler((CommonErrorHandler)new CommonLoggingErrorHandler());
        return factory;
    }

    @Bean
    public KafkaListenerContainerFactory<ConcurrentMessageListenerContainer<ItemId, ItemId>> itemIdItemIdConsumer(@Value(value="${just.drive.kafka.boostrapServers:}") String bootstrapServer) {
        HashMap props = this.newConsumerFactoryPropsWithDefaults(bootstrapServer);
        props.put("spring.deserializer.key.delegate.class", ItemIdDeserializer.class);
        props.put("spring.deserializer.value.delegate.class", ItemIdDeserializer.class);
        ConcurrentKafkaListenerContainerFactory factory = new ConcurrentKafkaListenerContainerFactory();
        factory.setConsumerFactory((ConsumerFactory)new DefaultKafkaConsumerFactory((Map)props));
        factory.setCommonErrorHandler((CommonErrorHandler)new DefaultErrorHandler());
        return factory;
    }

    @Bean
    public NewTopic sharesTopic() {
        NewTopic topic = new NewTopic("just.drive.shares", 1, 1);
        return topic.configs((Map)DEFAULT_TOPIC_CONFIG);
    }

    @Bean
    public NewTopic searchIndexContentTopic() {
        NewTopic topic = new NewTopic("just.search.index.content", 13, 1);
        return topic.configs((Map)DEFAULT_TOPIC_CONFIG);
    }

    @Bean
    public NewTopic virusScanTopic() {
        NewTopic topic = new NewTopic("just.virus.scan", 6, 1);
        return topic.configs((Map)DEFAULT_TOPIC_CONFIG);
    }

    @Bean
    public NewTopic virusScanResultTopic() {
        NewTopic topic = new NewTopic("just.virus.scan.results", 1, 1);
        return topic.configs((Map)DEFAULT_TOPIC_CONFIG);
    }
}

