/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.drive.business.kafka;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableSet;
import de.justsoftware.drive.business.kafka.NotificationConnector;
import de.justsoftware.drive.business.server.business.AdaApiConnector;
import de.justsoftware.drive.common.document.model.DocumentId;
import de.justsoftware.drive.common.item.model.ItemId;
import de.justsoftware.drive.common.tenant.model.TenantId;
import de.justsoftware.notificationclient.NotificationProducer;
import de.justsoftware.notificationclient.model.Notification;
import de.justsoftware.notificationclient.model.NotificationType;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class NotificationConnector {
    private static final Logger LOG = LoggerFactory.getLogger(NotificationConnector.class);
    private static final ObjectMapper MAPPER = new ObjectMapper();
    private static final String ANTIVIRUS_UI_URL = "/admin/app/drive/antivirus";
    private final String _appId = "drive";
    private final NotificationProducer _notificationProducer;
    private final AdaApiConnector _adaApiConnector;

    @Autowired
    NotificationConnector(NotificationProducer notificationProducer, AdaApiConnector adaApiConnector) {
        this._notificationProducer = notificationProducer;
        this._adaApiConnector = adaApiConnector;
    }

    public void sendVirusFoundNotification(TenantId tenantId, String fileName) {
        Set tenantManagers = this._adaApiConnector.getTenantManagers(tenantId);
        Map<Locale, String> localTitle = Map.of(Locale.GERMAN, "Virus gefunden", Locale.ENGLISH, "Virus detected");
        Map<Locale, String> localText = Map.of(Locale.GERMAN, String.format("In der Datei \"%s\" wurde ein Virus gefunden. ", fileName), Locale.ENGLISH, String.format("A virus has been detected in the file \"%s\"", fileName));
        if (tenantManagers.isEmpty()) {
            LOG.warn("No tenant manager found not sending any notification");
            return;
        }
        this._notificationProducer.dispatchNotification(Notification.builder((UUID)((UUID)tenantId.getId()), (String)"drive", (String)localTitle.get(Locale.GERMAN), (String)localText.get(Locale.GERMAN), (NotificationType)NotificationType.VIRUS_FOUND).withLocalizedTitle(localTitle).withLocalizedText(localText).withReceivers(tenantManagers).withTargetId(ANTIVIRUS_UI_URL).build());
    }

    public void sendShareRequestNotification(TenantId tenantId, String shareName, ItemId shareId, DocumentId rootFolderId, String requesterFullName, ImmutableSet<String> receiverIds) {
        Map<Locale, String> localTitle = Map.of(Locale.GERMAN, "Anfrage zum Laufwerk", Locale.ENGLISH, "Drive access request");
        Map<Locale, String> localText = Map.of(Locale.GERMAN, String.format("%s bittet um Zugang zum Laufwerk \"%s\".", requesterFullName, shareName), Locale.ENGLISH, String.format("%s has requested access to the share \"%s\".", requesterFullName, shareName));
        this.sendNotifications(tenantId, shareId, rootFolderId, receiverIds, NotificationType.DRIVE_SHARE_ACCESS_REQUEST, localTitle, localText);
    }

    public void sendShareGrantNotification(TenantId tenantId, String shareName, ItemId shareId, DocumentId rootFolderId, String executorFullName, ImmutableSet<String> receiverIds) {
        Map<Locale, String> localTitle = Map.of(Locale.GERMAN, "Neue Zugriffsberechtigung", Locale.ENGLISH, "Access authorization");
        Map<Locale, String> localText = Map.of(Locale.GERMAN, String.format("%s hat dir Berechtigung zu dem Laufwerk \"%s\" gegeben.", executorFullName, shareName), Locale.ENGLISH, String.format("%s granted you access to the share \"%s\"", executorFullName, shareName));
        this.sendNotifications(tenantId, shareId, rootFolderId, receiverIds, NotificationType.DRIVE_SHARE_ACCESS_GRANT, localTitle, localText);
    }

    private void sendNotifications(TenantId tenantId, ItemId shareId, DocumentId rootFolderId, ImmutableSet<String> receiverIds, NotificationType notificationType, Map<Locale, String> localTitle, Map<Locale, String> localText) {
        if (!receiverIds.isEmpty()) {
            String payload;
            try {
                payload = MAPPER.writeValueAsString((Object)new NotificationPayload("drive", rootFolderId.toUUIDString()));
            }
            catch (JsonProcessingException e) {
                LOG.error("error while creating notification payload JSON string", (Throwable)e);
                return;
            }
            this._notificationProducer.dispatchNotification(Notification.builder((UUID)((UUID)tenantId.getId()), (String)"drive", (String)localTitle.get(Locale.GERMAN), (String)localText.get(Locale.GERMAN), (NotificationType)notificationType).withLocalizedTitle(localTitle).withLocalizedText(localText).withReceivers(receiverIds).withPayload(payload).withTargetId((String)shareId.getId()).build());
        }
    }
}

