/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.drive.business.judo;

import de.justsoftware.drive.business.judo.JudoClient;
import de.justsoftware.drive.common.file.model.PreviewId;
import de.justsoftware.drive.filepersistence.common.SslAwareRequestFactoryProvider;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLConnection;
import java.time.Duration;
import java.util.Set;
import javax.net.ssl.HttpsURLConnection;
import org.apache.kafka.clients.producer.Producer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.ssl.SslBundle;
import org.springframework.boot.ssl.SslBundles;
import org.springframework.stereotype.Service;
import org.springframework.web.client.RestClient;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class JudoClient {
    public static final String JUST_DOCUMENT_PREVIEW_DELETION_TOPIC = "just.documents.preview.deletion";
    private static final String URL_DOCUMENT_API_DOCUMENTS = "/api/v1/documents";
    private static final Logger LOG = LogManager.getLogger(JudoClient.class);
    private static final Duration JUDO_LONG_READ_TIMEOUT = Duration.ofMinutes(120L);
    private static final Duration JUDO_CONNECT_TIMEOUT = Duration.ofSeconds(10L);
    private final Producer<String, String> _producer;
    private final String _judoUrl;
    private final RestClient _defaultRestClient;
    private final RestClient _highReadTimeoutClient;
    private final SslBundle _justSsl;

    @Autowired
    public JudoClient(Producer<String, String> producer, RestClient.Builder restClientBuilder, @Value(value="${just.drive.judo.url}") String judoUrl, SslAwareRequestFactoryProvider requestFactoryProvider, SslBundles ssl) {
        this._justSsl = ssl.getBundle("just");
        this._producer = producer;
        this._judoUrl = judoUrl;
        this._defaultRestClient = restClientBuilder.baseUrl(judoUrl).requestFactory(requestFactoryProvider.create(settings -> settings.withConnectTimeout(JUDO_CONNECT_TIMEOUT))).build();
        this._highReadTimeoutClient = restClientBuilder.baseUrl(judoUrl).requestFactory(requestFactoryProvider.create(settings -> settings.withConnectTimeout(JUDO_CONNECT_TIMEOUT).withReadTimeout(JUDO_LONG_READ_TIMEOUT))).build();
    }

    public void deletePreview(PreviewId previewId) {
        LOG.info("Queueing preview deletion for {}", (Object)previewId);
        this._producer.send(new ProducerRecord("just.documents.preview.deletion", (Object)previewId.toString(), null));
    }

    public void deletePreviews(Set<PreviewId> documentIds) {
        documentIds.forEach(arg_0 -> this.deletePreview(arg_0));
    }

    public boolean isAvailable() {
        return this._defaultRestClient.get().uri("/internal/monitoring/info", new Object[0]).retrieve().toBodilessEntity().getStatusCode().is2xxSuccessful();
    }

    public void deletePreviewSources() {
        this._highReadTimeoutClient.delete().uri("/api/v1/documents/deletePreviewSources", new Object[0]).retrieve().toBodilessEntity();
    }

    public JudoDocumentInputStream getDocumentResource(PreviewId previewId, String relativeResourcePath) throws JudoApiException {
        return this.fetchContent("/" + (String)previewId.getId() + "/HTML/" + relativeResourcePath);
    }

    private JudoDocumentInputStream fetchContent(String target) throws JudoApiException {
        try {
            URI uri = new URI(this._judoUrl + "/content" + target);
            URLConnection connection = uri.toURL().openConnection();
            if (connection instanceof HttpsURLConnection) {
                HttpsURLConnection httpsConnection = (HttpsURLConnection)connection;
                httpsConnection.setSSLSocketFactory(this._justSsl.createSslContext().getSocketFactory());
            }
            return JudoDocumentInputStream.from((URLConnection)connection);
        }
        catch (MalformedURLException e) {
            throw new JudoApiException("Target URL is invalid : " + target, (Exception)e);
        }
        catch (IOException e) {
            throw new JudoApiException("Error fetching document from : " + target, (Exception)e);
        }
        catch (URISyntaxException e) {
            throw new JudoApiException("Wrong URI syntax for:" + target, (Exception)e);
        }
    }
}

