/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.drive.business.item.impl;

import com.google.common.collect.ImmutableMap;
import de.justsoftware.drive.business.item.ItemReadService;
import de.justsoftware.drive.common.item.model.ItemBO;
import de.justsoftware.drive.common.item.model.ItemId;
import de.justsoftware.drive.common.item.model.ItemType;
import de.justsoftware.drive.common.tenant.model.TenantId;
import de.justsoftware.drive.persistence.item.ItemDAO;
import java.time.Duration;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import org.jspecify.annotations.Nullable;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ItemReadServiceImpl
implements ItemReadService {
    private final ItemDAO _itemDAO;

    @Autowired
    public ItemReadServiceImpl(ItemDAO itemDAO) {
        this._itemDAO = itemDAO;
    }

    public ImmutableMap<ItemId, ItemBO> getItems(Set<ItemId> itemIds) {
        return this._itemDAO.getItems(itemIds);
    }

    public int forAllItemsWithDocuments(int chunkSize, Consumer<List<ItemId>> consumer) {
        return this._itemDAO.forAllItemsWithDocuments(chunkSize, consumer);
    }

    public int forAllShares(Consumer<ItemBO> shareConsumer) {
        return this._itemDAO.forAllShares(shareConsumer);
    }

    public Set<ItemId> getDeletedItemsForTypes(Duration deletedForMoreThan, Set<ItemType> itemTypes) {
        return this._itemDAO.getDeletedItemsForTypes(deletedForMoreThan, itemTypes);
    }

    public Set<ItemId> getAllShareIds(TenantId tenantId) {
        return this._itemDAO.getAllShareIds(tenantId);
    }

    public Set<ItemBO> getAllSharesForTenant(TenantId tenantId) {
        return this._itemDAO.getAllSharesForTenant(tenantId);
    }

    public @Nullable ItemBO findItem(ItemId itemId) {
        return this._itemDAO.findItem(itemId);
    }
}

