/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.drive.business.document.util;

import java.util.LinkedList;
import java.util.Queue;
import java.util.function.BiConsumer;
import java.util.function.Consumer;

public class SplitConsumer<L, R> {
    private final BiConsumer<L, R> _delegate;
    private final Queue<L> _leftQueue = new LinkedList();
    private final Queue<R> _rightQueue = new LinkedList();
    public final Consumer<L> _left = l -> this.accept(this._leftQueue, l);
    public final Consumer<R> _right = r -> this.accept(this._rightQueue, r);

    public SplitConsumer(BiConsumer<L, R> delegate) {
        this._delegate = delegate;
    }

    private <T> void accept(Queue<T> list, T value) {
        list.add(value);
        if (!this._leftQueue.isEmpty() && !this._rightQueue.isEmpty()) {
            this._delegate.accept(this._leftQueue.remove(), this._rightQueue.remove());
        }
    }
}

