/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.drive.business.document.util;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import com.google.common.io.ByteSource;
import com.google.common.io.Files;
import com.google.common.net.MediaType;
import de.justsoftware.drive.business.document.util.FileType;
import de.justsoftware.drive.common.util.FileExtensionSanitizer;
import java.io.IOException;
import java.io.InputStream;
import java.util.Locale;
import org.apache.tika.Tika;
import org.apache.tika.io.TikaInputStream;
import org.apache.tika.metadata.Metadata;
import org.jspecify.annotations.Nullable;

/*
 * Exception performing whole class analysis ignored.
 */
public class FileMetaInfoUtil {
    public static final MediaType FOLDER = MediaType.create((String)"inode", (String)"directory");
    public static final MediaType MKV = MediaType.create((String)"video", (String)"mkv");
    public static final MediaType VOB = MediaType.create((String)"video", (String)"vob");
    public static final MediaType AVI = MediaType.create((String)"video", (String)"avi");
    static final MediaType PLAIN_TEXT = MediaType.create((String)"text", (String)"plain");
    static final MediaType HTML = MediaType.create((String)"text", (String)"html");
    static final MediaType OTT = MediaType.create((String)"application", (String)"vnd.oasis.opendocument.text-template");
    static final MediaType OTP = MediaType.create((String)"application", (String)"vnd.oasis.opendocument.presentation-template");
    static final MediaType OTS = MediaType.create((String)"application", (String)"vnd.oasis.opendocument.spreadsheet-template");
    static final MediaType OTG = MediaType.create((String)"application", (String)"vnd.oasis.opendocument.graphics-template");
    static final MediaType RTF = MediaType.create((String)"application", (String)"rtf");
    static final MediaType NUMBERS = MediaType.create((String)"application", (String)"vnd.apple.numbers");
    static final MediaType PAGES = MediaType.create((String)"application", (String)"vnd.apple.pages");
    static final MediaType KEYNOTE = MediaType.create((String)"application", (String)"vnd.apple.keynote");
    static final MediaType ALTERNATIVE_MICROSOFT_WORD = MediaType.create((String)"application", (String)"ms-word");
    static final MediaType ALTERNATIVE_MICROSOFT_POWERPOINT = MediaType.create((String)"application", (String)"ms-powerpoint");
    static final MediaType ALTERNATIVE_MICROSOFT_EXCEL = MediaType.create((String)"application", (String)"ms-excel");
    private static final Tika TIKA = new Tika();
    private static final Locale FILENAME_LOCALE = Locale.US;
    private static final ImmutableMap<MediaType, MediaType> ALTERNATIVE_MIME_TYPE_TO_ACTUAL_MIME_TYPE = ImmutableMap.builder().put((Object)ALTERNATIVE_MICROSOFT_WORD, (Object)MediaType.MICROSOFT_WORD).put((Object)ALTERNATIVE_MICROSOFT_POWERPOINT, (Object)MediaType.MICROSOFT_POWERPOINT).put((Object)ALTERNATIVE_MICROSOFT_EXCEL, (Object)MediaType.MICROSOFT_EXCEL).build();
    private static final ImmutableMap<String, MediaType> FILE_EXTENSION_TO_MIME_TYPE = ImmutableMap.builder().put((Object)"bin", (Object)MediaType.OCTET_STREAM).put((Object)"gif", (Object)MediaType.GIF).put((Object)"jpg", (Object)MediaType.JPEG).put((Object)"jpeg", (Object)MediaType.JPEG).put((Object)"jpe", (Object)MediaType.JPEG).put((Object)"png", (Object)MediaType.PNG).put((Object)"pdf", (Object)MediaType.PDF).put((Object)"doc", (Object)MediaType.MICROSOFT_WORD).put((Object)"docx", (Object)MediaType.OOXML_DOCUMENT).put((Object)"ppt", (Object)MediaType.MICROSOFT_POWERPOINT).put((Object)"pps", (Object)MediaType.MICROSOFT_POWERPOINT).put((Object)"pptx", (Object)MediaType.OOXML_PRESENTATION).put((Object)"xls", (Object)MediaType.MICROSOFT_EXCEL).put((Object)"xlsx", (Object)MediaType.OOXML_SHEET).put((Object)"txt", (Object)PLAIN_TEXT).put((Object)"zip", (Object)MediaType.ZIP).put((Object)"odt", (Object)MediaType.OPENDOCUMENT_TEXT).put((Object)"odp", (Object)MediaType.OPENDOCUMENT_PRESENTATION).put((Object)"ods", (Object)MediaType.OPENDOCUMENT_SPREADSHEET).put((Object)"odg", (Object)MediaType.OPENDOCUMENT_GRAPHICS).put((Object)"ott", (Object)OTT).put((Object)"otp", (Object)OTP).put((Object)"ots", (Object)OTS).put((Object)"otg", (Object)OTG).put((Object)"html", (Object)HTML).put((Object)"htm", (Object)HTML).put((Object)"rtf", (Object)RTF).put((Object)"numbers", (Object)NUMBERS).put((Object)"pages", (Object)PAGES).put((Object)"key", (Object)KEYNOTE).put((Object)"mp4", (Object)MediaType.MP4_VIDEO).put((Object)"mkv", (Object)MKV).put((Object)"webm", (Object)MediaType.ANY_VIDEO_TYPE).put((Object)"flv", (Object)MediaType.FLV_VIDEO).put((Object)"vob", (Object)VOB).put((Object)"ogg", (Object)MediaType.OGG_VIDEO).put((Object)"avi", (Object)AVI).put((Object)"wmv", (Object)MediaType.WMV).put((Object)"mpeg", (Object)MediaType.MPEG_VIDEO).put((Object)"3gp", (Object)MediaType.THREE_GPP_VIDEO).put((Object)"3g2", (Object)MediaType.THREE_GPP2_VIDEO).build();
    private static final ImmutableMap<MediaType, String> MIME_TYPE_TO_FILE_EXTENSION = ImmutableMap.builder().put((Object)MediaType.OCTET_STREAM, (Object)"bin").put((Object)MediaType.GIF, (Object)"gif").put((Object)MediaType.JPEG, (Object)"jpg").put((Object)MediaType.PNG, (Object)"png").put((Object)MediaType.PDF, (Object)"pdf").put((Object)MediaType.MICROSOFT_WORD, (Object)"doc").put((Object)MediaType.OOXML_DOCUMENT, (Object)"docx").put((Object)MediaType.MICROSOFT_POWERPOINT, (Object)"ppt").put((Object)MediaType.OOXML_PRESENTATION, (Object)"pptx").put((Object)MediaType.MICROSOFT_EXCEL, (Object)"xls").put((Object)MediaType.OOXML_SHEET, (Object)"xlsx").put((Object)PLAIN_TEXT, (Object)"txt").put((Object)MediaType.PLAIN_TEXT_UTF_8, (Object)"txt").put((Object)MediaType.ZIP, (Object)"zip").put((Object)MediaType.OPENDOCUMENT_TEXT, (Object)"odt").put((Object)MediaType.OPENDOCUMENT_PRESENTATION, (Object)"odp").put((Object)MediaType.OPENDOCUMENT_SPREADSHEET, (Object)"ods").put((Object)MediaType.OPENDOCUMENT_GRAPHICS, (Object)"odg").put((Object)OTT, (Object)"ott").put((Object)OTP, (Object)"otp").put((Object)OTS, (Object)"ots").put((Object)OTG, (Object)"otg").put((Object)HTML, (Object)"html").put((Object)MediaType.HTML_UTF_8, (Object)"html").put((Object)RTF, (Object)"rtf").put((Object)NUMBERS, (Object)"numbers").put((Object)PAGES, (Object)"pages").put((Object)KEYNOTE, (Object)"key").put((Object)MediaType.MP4_VIDEO, (Object)"mp4").put((Object)MKV, (Object)"mkv").put((Object)MediaType.ANY_VIDEO_TYPE, (Object)"webm").put((Object)MediaType.FLV_VIDEO, (Object)"flv").put((Object)VOB, (Object)"vob").put((Object)MediaType.OGG_VIDEO, (Object)"ogg").put((Object)AVI, (Object)"avi").put((Object)MediaType.WMV, (Object)"wmv").put((Object)MediaType.MPEG_VIDEO, (Object)"mpeg").put((Object)MediaType.THREE_GPP_VIDEO, (Object)"3gp").put((Object)MediaType.THREE_GPP2_VIDEO, (Object)"3g2").build();

    public static String getMimeTypeFromSource(String filename, ByteSource source) {
        String string;
        block8: {
            InputStream stream = source.openStream();
            try {
                TikaInputStream tikaInputStream = TikaInputStream.get((InputStream)stream);
                Metadata metadata = new Metadata();
                metadata.set("resourceName", filename);
                String mimeTypeString = TIKA.detect((InputStream)tikaInputStream, metadata);
                string = FileMetaInfoUtil.getMimeType((String)filename, (String)mimeTypeString);
                if (stream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException iOException) {
                    return FileMetaInfoUtil.getMimeType((String)filename, null);
                }
            }
            stream.close();
        }
        return string;
    }

    @VisibleForTesting
    protected static String getMimeType(String filename, @Nullable String mimeType) {
        MediaType parsedMimeType = FileMetaInfoUtil.parse((String)mimeType);
        if (parsedMimeType != null && parsedMimeType != MediaType.OCTET_STREAM) {
            return parsedMimeType.toString();
        }
        String fileExtension = FileMetaInfoUtil.getFileExtension((String)filename);
        if (FILE_EXTENSION_TO_MIME_TYPE.containsKey((Object)fileExtension)) {
            return ((MediaType)FILE_EXTENSION_TO_MIME_TYPE.get((Object)fileExtension)).toString();
        }
        return MediaType.OCTET_STREAM.toString();
    }

    public static String getFileExtension(String filename, @Nullable String mimeType) {
        String fileExtension = FileMetaInfoUtil.getFileExtension((String)filename);
        if (!Strings.isNullOrEmpty((String)fileExtension)) {
            return fileExtension;
        }
        MediaType parsedMimeType = FileMetaInfoUtil.parse((String)mimeType);
        if (parsedMimeType != null && MIME_TYPE_TO_FILE_EXTENSION.containsKey((Object)parsedMimeType)) {
            return (String)MIME_TYPE_TO_FILE_EXTENSION.get((Object)parsedMimeType);
        }
        return "";
    }

    private static String getFileExtension(String filename) {
        String unsafeExtension = Files.getFileExtension((String)filename.toLowerCase(FILENAME_LOCALE).trim());
        return FileExtensionSanitizer.stripNonAlphanumericContent((String)unsafeExtension);
    }

    private static @Nullable MediaType parse(@Nullable String mimeTypeString) {
        if (mimeTypeString == null) {
            return null;
        }
        try {
            MediaType parsedMimeType = MediaType.parse((String)mimeTypeString);
            return (MediaType)ALTERNATIVE_MIME_TYPE_TO_ACTUAL_MIME_TYPE.getOrDefault((Object)parsedMimeType, (Object)parsedMimeType);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    public static FileType getFileType(String mimeType) {
        MediaType parsedMimeType = FileMetaInfoUtil.parse((String)mimeType);
        if (parsedMimeType != null) {
            for (FileType fileType : FileType.values()) {
                if (fileType == FileType.MISC || !fileType.contains(parsedMimeType)) continue;
                return fileType;
            }
        }
        return FileType.MISC;
    }
}

