/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.drive.business.document.impl;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import de.justsoftware.drive.business.document.IllegalCharDocumentNameBusinessException;
import de.justsoftware.drive.business.document.IllegalEmptyDocumentNameBusinessException;
import de.justsoftware.drive.business.document.NameValidation;
import de.justsoftware.drive.business.document.UniqueNameService;
import de.justsoftware.drive.business.document.impl.UniqueNameServiceImpl;
import de.justsoftware.drive.business.exception.UnknownResourceBusinessException;
import de.justsoftware.drive.business.folder.FolderService;
import de.justsoftware.drive.common.document.model.DocumentId;
import de.justsoftware.drive.common.document.model.DocumentVersionBO;
import de.justsoftware.drive.common.document.model.DocumentVersionId;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.jspecify.annotations.Nullable;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class UniqueNameServiceImpl
implements UniqueNameService {
    private static final Pattern SPLIT_FILE = Pattern.compile("([^.]*)(\\..*)?");
    private static final String FORBIDDEN_CHARS = "/<>\\:?*\"|";
    private final FolderService _folderService;

    @Autowired
    public UniqueNameServiceImpl(FolderService folderService) {
        this._folderService = folderService;
    }

    public UniqueNameService.UniqueNameCache forFolder(DocumentId folderId, NameValidation nameValidation) {
        DocumentVersionId versionId = (DocumentVersionId)this._folderService.getLastVersionsOfDocuments((Set)ImmutableSet.of((Object)folderId)).get((Object)folderId);
        if (versionId == null) {
            throw new UnknownResourceBusinessException("Found no current version of folder with ID " + String.valueOf(folderId));
        }
        ImmutableList contents = this._folderService.getFolderContents((Set)ImmutableSet.of((Object)versionId)).get((Object)versionId);
        ImmutableMap byId = Maps.uniqueIndex((Iterable)contents, (Function)DocumentVersionBO.GET_DOCUMENT_ID);
        Map names = Maps.transformValues((Map)byId, DocumentVersionBO::getName);
        return new UniqueNameCacheImpl(names, nameValidation);
    }

    @VisibleForTesting
    static String checkName(@Nullable String name, NameValidation nameValidation) {
        String trimmed = Strings.nullToEmpty((String)name).trim();
        StringBuilder result = new StringBuilder();
        if (trimmed.isEmpty()) {
            switch (1.$SwitchMap$de$justsoftware$drive$business$document$NameValidation[nameValidation.ordinal()]) {
                case 1: {
                    return "no name";
                }
                case 2: {
                    throw new IllegalEmptyDocumentNameBusinessException();
                }
            }
        }
        boolean lastUnderscore = false;
        for (char ch : trimmed.toCharArray()) {
            if (FORBIDDEN_CHARS.indexOf(ch) != -1) {
                switch (1.$SwitchMap$de$justsoftware$drive$business$document$NameValidation[nameValidation.ordinal()]) {
                    case 1: {
                        if (lastUnderscore) break;
                        lastUnderscore = true;
                        result.append('_');
                        break;
                    }
                    case 2: {
                        throw new IllegalCharDocumentNameBusinessException(ch);
                    }
                }
                continue;
            }
            result.append(ch);
            lastUnderscore = ch == '_';
        }
        return result.toString();
    }
}

