/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.drive.business.change.impl;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import de.justsoftware.drive.business.change.ChangeModificationService;
import de.justsoftware.drive.business.document.DocumentTreeModificationService;
import de.justsoftware.drive.business.exception.UnknownResourceBusinessException;
import de.justsoftware.drive.common.change.model.ChangeBO;
import de.justsoftware.drive.common.item.model.ItemId;
import de.justsoftware.drive.common.person.model.PersonId;
import de.justsoftware.drive.persistence.change.ChangeDAO;
import java.util.Map;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ChangeModificationServiceImpl
implements ChangeModificationService {
    private final ChangeDAO _changeDAO;
    private final DocumentTreeModificationService _documentTreeModificationService;

    @Autowired
    public ChangeModificationServiceImpl(DocumentTreeModificationService documentTreeModificationService, ChangeDAO changeDAO) {
        this._documentTreeModificationService = documentTreeModificationService;
        this._changeDAO = changeDAO;
    }

    public ChangeBO getOrCreateNewestChange(ItemId itemId, PersonId owner) {
        ChangeBO newestChange = (ChangeBO)this._changeDAO.getNewestChangePerItem((Set)ImmutableSet.of((Object)itemId)).get((Object)itemId);
        if (newestChange != null) {
            return newestChange;
        }
        this._documentTreeModificationService.createRootFolders((Map)ImmutableMap.of((Object)itemId, (Object)owner));
        return (ChangeBO)UnknownResourceBusinessException.checkNotNull((Object)((ChangeBO)this._changeDAO.getNewestChangePerItem((Set)ImmutableSet.of((Object)itemId)).get((Object)itemId)), (String)("Created a new change but it can't be loaded " + String.valueOf(itemId)));
    }

    public void createRootFoldersIfNecessary(Map<ItemId, PersonId> owners) {
        ImmutableMap existing = this._changeDAO.getNewestChangePerItem(owners.keySet());
        Map ownersOfMissing = Maps.filterKeys(owners, (Predicate)Predicates.not(arg_0 -> ((ImmutableSet)existing.keySet()).contains(arg_0)));
        this._documentTreeModificationService.createRootFolders(ownersOfMissing);
    }
}

