/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.drive.business.authorization;

import com.google.common.base.MoreObjects;
import com.google.common.base.Optional;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.SetMultimap;
import de.justsoftware.drive.common.authorization.model.StaticAction;
import de.justsoftware.drive.common.model.AbstractId;
import de.justsoftware.drive.common.person.model.PersonId;
import de.justsoftware.drive.common.util.AbstractImmutableEqualsObject;
import org.jspecify.annotations.Nullable;

public final class AuthorizationKey<I extends AbstractId<?>>
extends AbstractImmutableEqualsObject {
    private final Optional<? extends I> _id;
    private final StaticAction _action;
    private final PersonId _personId;

    public AuthorizationKey(PersonId personId, Optional<? extends I> id, StaticAction action) {
        super(new Object[]{personId, id, action});
        this._personId = personId;
        this._id = id;
        this._action = action;
    }

    public AuthorizationKey(PersonId personId, @Nullable I id, StaticAction action) {
        this(personId, Optional.fromNullable(id), action);
    }

    public AuthorizationKey(PersonId personId, StaticAction action) {
        this(personId, Optional.absent(), action);
    }

    public Optional<? extends I> getId() {
        return this._id;
    }

    public @Nullable I getNullableId() {
        return (I)((AbstractId)this._id.orNull());
    }

    public StaticAction getAction() {
        return this._action;
    }

    public PersonId getPersonId() {
        return this._personId;
    }

    public static <I extends AbstractId<?>> ImmutableSet<AuthorizationKey<I>> forSetMultimap(SetMultimap<I, StaticAction> actions, PersonId personId) {
        return FluentIterable.from((Iterable)actions.entries()).transform(input -> new AuthorizationKey(personId, (AbstractId)input.getKey(), (StaticAction)input.getValue())).toSet();
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("id", (Object)this._id).add("personId", (Object)this._personId).add("action", (Object)this._action).toString();
    }
}

