/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.drive.batch.item;

import com.google.common.collect.ImmutableSet;
import de.justsoftware.drive.business.common.JustConfig;
import de.justsoftware.drive.business.item.ItemPurgeService;
import de.justsoftware.drive.business.item.ItemReadService;
import de.justsoftware.drive.common.item.model.ItemType;
import java.time.Duration;
import java.util.Date;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.scheduling.TaskScheduler;
import org.springframework.scheduling.Trigger;
import org.springframework.scheduling.TriggerContext;
import org.springframework.scheduling.support.CronTrigger;
import org.springframework.scheduling.support.SimpleTriggerContext;
import org.springframework.stereotype.Service;

@Service
@ConditionalOnProperty(value={"just.drive.itempurge.enabled", "just.drive.batchprocessing.enabled"})
public class ItemPurgeSchedulerService
implements InitializingBean {
    private static final Logger LOG = LoggerFactory.getLogger(ItemPurgeSchedulerService.class);
    private static final CronTrigger CRON_TRIGGER = new CronTrigger("0 0 6 * * *");
    private final ItemReadService _itemReadService;
    private final ItemPurgeService _itemPurgeService;
    private final TaskScheduler _taskScheduler;
    private final JustConfig _deletionConfig;

    @Autowired
    public ItemPurgeSchedulerService(ItemReadService itemReadService, ItemPurgeService itemPurgeService, TaskScheduler taskScheduler, JustConfig deletionConfig) {
        this._itemReadService = itemReadService;
        this._itemPurgeService = itemPurgeService;
        this._taskScheduler = taskScheduler;
        this._deletionConfig = deletionConfig;
    }

    public void afterPropertiesSet() {
        Date nextExecution = CRON_TRIGGER.nextExecutionTime((TriggerContext)new SimpleTriggerContext());
        LOG.info("Schedule job to purge deleted items from database. Next execution at {}.", (Object)nextExecution);
        this._taskScheduler.schedule(() -> this.purgeDeletedItems(), (Trigger)CRON_TRIGGER);
    }

    public void purgeDeletedItemsNow() {
        this.purgeDeletedItems();
    }

    private void purgeDeletedItems() {
        this.purgeTypes(this._deletionConfig.getChat().getCleanupAfter(), (Set)ImmutableSet.of((Object)ItemType.CHAT, (Object)ItemType.CHAT_ASSET));
        this.purgeTypes(this._deletionConfig.getWiki().getCleanupAfter(), (Set)ImmutableSet.of((Object)ItemType.WIKI_WIKI, (Object)ItemType.WIKI_ARTICLE));
        this.purgeTypes(this._deletionConfig.getNews().getDeletionDelay(), (Set)ImmutableSet.of((Object)ItemType.COMMENT, (Object)ItemType.POST));
        this.purgeTypes(this._deletionConfig.getDrive().getDeletionDelay(), (Set)ImmutableSet.of((Object)ItemType.SHARE, (Object)ItemType.TENANT));
    }

    private void purgeTypes(Duration deletionDelay, Set<ItemType> itemTypes) {
        if (deletionDelay.isNegative()) {
            LOG.info("will not delete items of type {}", itemTypes);
            return;
        }
        LOG.info("Purge items of types {} that are deleted for more than {} days.", itemTypes, (Object)deletionDelay.toDays());
        Set deletedItems = this._itemReadService.getDeletedItemsForTypes(deletionDelay, itemTypes);
        Set purgedItems = this._itemPurgeService.purge(deletedItems);
        LOG.info("Purged {} items.", (Object)purgedItems.size());
    }
}

