/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.drive.batch.impl;

import de.justsoftware.drive.business.judo.JudoClient;
import de.justsoftware.drive.persistence.file.FileVersionPreviewDAO;
import java.io.IOException;
import java.io.UncheckedIOException;
import org.apache.ibatis.cursor.Cursor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class FileVersionPreviewScheduledCleanup {
    private static final Logger LOG = LoggerFactory.getLogger(FileVersionPreviewScheduledCleanup.class);
    private final FileVersionPreviewDAO _fileVersionPreviewDAO;
    private final JudoClient _judoClient;

    @Autowired
    public FileVersionPreviewScheduledCleanup(FileVersionPreviewDAO fileVersionPreviewDAO, JudoClient judoClient) {
        this._fileVersionPreviewDAO = fileVersionPreviewDAO;
        this._judoClient = judoClient;
    }

    @Transactional
    @Scheduled(fixedDelayString="${just.drive.file.preview.outdatedCleanupDelay:1d}", initialDelayString="${just.drive.file.preview.outdatedCleanupInitialDelay:1h}")
    void cleanup() {
        LOG.info("Scheduled cleanup of outdated previews");
        try (Cursor cursor = this._fileVersionPreviewDAO.streamOutdatedVersionPreviewIds();){
            cursor.forEach(id -> {
                this._judoClient.deletePreview(id);
                this._fileVersionPreviewDAO.markAsDeleted(id);
            });
        }
        catch (IOException e) {
            throw new UncheckedIOException("Failed to close cursor during preview cleanup", e);
        }
    }
}

