/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.justdocumentz.virusscan;

import de.justsoftware.justdocumentz.common.ContainerImageService;
import de.justsoftware.justdocumentz.common.ContainerManageService;
import de.justsoftware.justdocumentz.config.JudoConfig;
import de.justsoftware.justdocumentz.config.PodmanConfig;
import de.justsoftware.justdocumentz.connector.SuperopertyConnector;
import de.justsoftware.justdocumentz.events.AntivirusAvailabilityChangedEvent;
import de.justsoftware.justdocumentz.util.FileUtilsKt;
import java.nio.file.Path;
import java.time.ZoneId;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import org.apache.curator.framework.recipes.cache.TreeCacheEvent;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.actuate.health.AbstractHealthIndicator;
import org.springframework.boot.actuate.health.Health;
import org.springframework.boot.actuate.health.Status;
import org.springframework.boot.context.event.ApplicationStartedEvent;
import org.springframework.cloud.endpoint.event.RefreshEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.annotation.Scope;
import org.springframework.context.event.ContextClosedEvent;
import org.springframework.context.event.EventListener;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Component;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Component
@Scope(value="singleton")
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0006\b\u0017\u0018\u00002\u00020\u0001B5\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000eJ\u0010\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#H\u0014J\u001b\u0010$\u001a\b\u0012\u0004\u0012\u00020!0%H\u0017\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\b&\u0010'J\u0010\u0010(\u001a\u00020!2\u0006\u0010)\u001a\u00020*H\u0017J\u0010\u0010+\u001a\u00020!2\u0006\u0010)\u001a\u00020,H\u0017J\u0010\u0010-\u001a\u00020!2\u0006\u0010.\u001a\u00020/H\u0016J\b\u00100\u001a\u00020!H\u0012J\b\u00101\u001a\u00020!H\u0012J\u0015\u00102\u001a\u00020!2\u0006\u00103\u001a\u00020/H\u0010\u00a2\u0006\u0002\b4R\u0014\u0010\n\u001a\u00020\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0011\u001a\u00020\u0012X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0014\u0010\b\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0014\u0010\f\u001a\u00020\rX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u000e\u0010\u001b\u001a\u00020\u0012X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u001dX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001f\u0082\u0002\u000b\n\u0002\b!\n\u0005\b\u00a1\u001e0\u0001\u00a8\u00065"}, d2={"Lde/justsoftware/justdocumentz/virusscan/VirusScanDaemonRunner;", "Lorg/springframework/boot/actuate/health/AbstractHealthIndicator;", "config", "Lde/justsoftware/justdocumentz/config/JudoConfig;", "superopertyConnector", "Lde/justsoftware/justdocumentz/connector/SuperopertyConnector;", "containerImageService", "Lde/justsoftware/justdocumentz/common/ContainerImageService;", "containerManageService", "Lde/justsoftware/justdocumentz/common/ContainerManageService;", "applicationEventPublisher", "Lorg/springframework/context/ApplicationEventPublisher;", "environment", "Lorg/springframework/core/env/Environment;", "(Lde/justsoftware/justdocumentz/config/JudoConfig;Lde/justsoftware/justdocumentz/connector/SuperopertyConnector;Lde/justsoftware/justdocumentz/common/ContainerImageService;Lde/justsoftware/justdocumentz/common/ContainerManageService;Lorg/springframework/context/ApplicationEventPublisher;Lorg/springframework/core/env/Environment;)V", "getApplicationEventPublisher", "()Lorg/springframework/context/ApplicationEventPublisher;", "clamavImage", "", "getConfig", "()Lde/justsoftware/justdocumentz/config/JudoConfig;", "getContainerImageService", "()Lde/justsoftware/justdocumentz/common/ContainerImageService;", "getContainerManageService", "()Lde/justsoftware/justdocumentz/common/ContainerManageService;", "getEnvironment", "()Lorg/springframework/core/env/Environment;", "justContainerVersion", "logger", "Lorg/slf4j/Logger;", "getSuperopertyConnector", "()Lde/justsoftware/justdocumentz/connector/SuperopertyConnector;", "doHealthCheck", "", "builder", "Lorg/springframework/boot/actuate/health/Health$Builder;", "onApplicationStartedEvent", "Lkotlin/Result;", "onApplicationStartedEvent-d1pmJ48", "()Ljava/lang/Object;", "onContextClosedEvent", "event", "Lorg/springframework/context/event/ContextClosedEvent;", "onRefreshEvent", "Lorg/springframework/cloud/endpoint/event/RefreshEvent;", "publishAntivirusAvailability", "isAvailable", "", "startDaemon", "stopDaemon", "updateDaemon", "antivirusEnabled", "updateDaemon$just_documentz", "just-documentz"})
@SourceDebugExtension(value={"SMAP\nVirusScanDaemonRunner.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VirusScanDaemonRunner.kt\nde/justsoftware/justdocumentz/virusscan/VirusScanDaemonRunner\n+ 2 LoggerExtensions.kt\nde/justsoftware/justdocumentz/util/LoggerExtensionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,197:1\n9#2:198\n1#3:199\n1747#4,3:200\n*S KotlinDebug\n*F\n+ 1 VirusScanDaemonRunner.kt\nde/justsoftware/justdocumentz/virusscan/VirusScanDaemonRunner\n*L\n39#1:198\n114#1:200,3\n*E\n"})
public class VirusScanDaemonRunner
extends AbstractHealthIndicator {
    @NotNull
    private final JudoConfig config;
    @NotNull
    private final SuperopertyConnector superopertyConnector;
    @NotNull
    private final ContainerImageService containerImageService;
    @NotNull
    private final ContainerManageService containerManageService;
    @NotNull
    private final ApplicationEventPublisher applicationEventPublisher;
    @NotNull
    private final Environment environment;
    @NotNull
    private final Logger logger;
    @NotNull
    private final String justContainerVersion;
    @NotNull
    private final String clamavImage;

    public VirusScanDaemonRunner(@NotNull JudoConfig config, @NotNull SuperopertyConnector superopertyConnector, @NotNull ContainerImageService containerImageService, @NotNull ContainerManageService containerManageService, @NotNull ApplicationEventPublisher applicationEventPublisher, @NotNull Environment environment) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        Intrinsics.checkNotNullParameter((Object)superopertyConnector, (String)"superopertyConnector");
        Intrinsics.checkNotNullParameter((Object)containerImageService, (String)"containerImageService");
        Intrinsics.checkNotNullParameter((Object)containerManageService, (String)"containerManageService");
        Intrinsics.checkNotNullParameter((Object)applicationEventPublisher, (String)"applicationEventPublisher");
        Intrinsics.checkNotNullParameter((Object)environment, (String)"environment");
        this.config = config;
        this.superopertyConnector = superopertyConnector;
        this.containerImageService = containerImageService;
        this.containerManageService = containerManageService;
        this.applicationEventPublisher = applicationEventPublisher;
        this.environment = environment;
        VirusScanDaemonRunner $this$logger$iv = this;
        boolean $i$f$logger = false;
        Logger logger = LoggerFactory.getLogger(VirusScanDaemonRunner.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        this.logger = logger;
        String string = this.getEnvironment().getProperty("just.containerVersion", "latest");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getProperty(...)");
        this.justContainerVersion = string;
        this.clamavImage = "docker.io/justsocial/just-clamav:" + this.justContainerVersion;
    }

    @NotNull
    public JudoConfig getConfig() {
        return this.config;
    }

    @NotNull
    public SuperopertyConnector getSuperopertyConnector() {
        return this.superopertyConnector;
    }

    @NotNull
    public ContainerImageService getContainerImageService() {
        return this.containerImageService;
    }

    @NotNull
    public ContainerManageService getContainerManageService() {
        return this.containerManageService;
    }

    @NotNull
    public ApplicationEventPublisher getApplicationEventPublisher() {
        return this.applicationEventPublisher;
    }

    @NotNull
    public Environment getEnvironment() {
        return this.environment;
    }

    @EventListener(value={ApplicationStartedEvent.class})
    @NotNull
    public Object onApplicationStartedEvent-d1pmJ48() {
        Object object;
        block5: {
            Object object2;
            object = this;
            try {
                VirusScanDaemonRunner $this$onApplicationStartedEvent_d1pmJ48_u24lambda_u241 = object;
                boolean bl = false;
                if (!$this$onApplicationStartedEvent_d1pmJ48_u24lambda_u241.getSuperopertyConnector().getVirusScannerEnabled()) {
                    $this$onApplicationStartedEvent_d1pmJ48_u24lambda_u241.updateDaemon$just_documentz(false);
                } else {
                    $this$onApplicationStartedEvent_d1pmJ48_u24lambda_u241.logger.info("Initializing " + $this$onApplicationStartedEvent_d1pmJ48_u24lambda_u241.getClass().getSimpleName() + "...");
                    if (!$this$onApplicationStartedEvent_d1pmJ48_u24lambda_u241.getContainerImageService().isPodmanAvailable()) {
                        boolean $i$a$-check-VirusScanDaemonRunner$onApplicationStartedEvent$1$22 = false;
                        String $i$a$-check-VirusScanDaemonRunner$onApplicationStartedEvent$1$22 = "Podman is not available on this system. Please install Podman to use virus scan.";
                        throw new IllegalStateException($i$a$-check-VirusScanDaemonRunner$onApplicationStartedEvent$1$22.toString());
                    }
                    $this$onApplicationStartedEvent_d1pmJ48_u24lambda_u241.getContainerImageService().ensureImageAvailable($this$onApplicationStartedEvent_d1pmJ48_u24lambda_u241.clamavImage);
                    $this$onApplicationStartedEvent_d1pmJ48_u24lambda_u241.updateDaemon$just_documentz(true);
                }
                object2 = Result.constructor-impl((Object)Unit.INSTANCE);
            }
            catch (Throwable bl) {
                object2 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
            }
            object = object2;
            Throwable throwable = Result.exceptionOrNull-impl((Object)object);
            if (throwable == null) break block5;
            Object e = object2 = throwable;
            boolean bl = false;
            this.logger.error("Failed to initialize Clamav Daemon", (Throwable)e);
        }
        return object;
    }

    @EventListener
    public void onRefreshEvent(@NotNull RefreshEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Object object = event.getEvent();
        TreeCacheEvent treeCacheEvent = object instanceof TreeCacheEvent ? (TreeCacheEvent)object : null;
        if (Intrinsics.areEqual((Object)(treeCacheEvent != null && (treeCacheEvent = treeCacheEvent.getData()) != null ? treeCacheEvent.getPath() : null), (Object)"/just/config/just/drive/virusScannerEnabled")) {
            this.logger.info("Update Virus Scan Daemon due to RefreshEvent: " + event);
            this.updateDaemon$just_documentz(this.getSuperopertyConnector().getVirusScannerEnabled());
        }
    }

    @EventListener
    public void onContextClosedEvent(@NotNull ContextClosedEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        this.logger.info("Stop Virus Scan Daemon due to ContextClosedEvent: " + event);
        this.updateDaemon$just_documentz(false);
    }

    public void updateDaemon$just_documentz(boolean antivirusEnabled) {
        boolean running = ContainerManageService.isContainerRunning-HG0u8IE$default((ContainerManageService)this.getContainerManageService(), (String)"judo-clamd", (long)0L, (int)2, null);
        boolean healthy = running && ContainerManageService.runHealthcheck-HG0u8IE$default((ContainerManageService)this.getContainerManageService(), (String)"judo-clamd", (long)0L, (int)2, null);
        boolean shouldBeRunning = antivirusEnabled && !healthy;
        boolean shouldBeStopped = !antivirusEnabled && running;
        if (shouldBeRunning) {
            Object it;
            Object $this$updateDaemon_u24lambda_u243;
            VirusScanDaemonRunner virusScanDaemonRunner = this;
            try {
                $this$updateDaemon_u24lambda_u243 = virusScanDaemonRunner;
                boolean bl = false;
                $this$updateDaemon_u24lambda_u243.startDaemon();
                $this$updateDaemon_u24lambda_u243 = Result.constructor-impl((Object)Unit.INSTANCE);
            }
            catch (Throwable bl) {
                $this$updateDaemon_u24lambda_u243 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
            }
            virusScanDaemonRunner = $this$updateDaemon_u24lambda_u243;
            if (Result.isSuccess-impl((Object)virusScanDaemonRunner)) {
                it = (Unit)virusScanDaemonRunner;
                boolean bl = false;
                this.logger.info("Virus Scan Daemon has been started");
                this.publishAntivirusAvailability(true);
            }
            Throwable throwable = Result.exceptionOrNull-impl((Object)virusScanDaemonRunner);
            if (throwable != null) {
                Object it2 = it = throwable;
                boolean bl = false;
                this.logger.error("Error while starting Virus Scan Daemon.", (Throwable)it2);
                this.logger.warn("Now trying to stop the Virus Scan Daemon completely, to prevent remaining in a 'hanging' state");
                this.updateDaemon$just_documentz(false);
            }
        } else if (shouldBeStopped) {
            Object $this$updateDaemon_u24lambda_u246;
            VirusScanDaemonRunner virusScanDaemonRunner = this;
            try {
                $this$updateDaemon_u24lambda_u246 = virusScanDaemonRunner;
                boolean bl = false;
                $this$updateDaemon_u24lambda_u246.publishAntivirusAvailability(false);
                $this$updateDaemon_u24lambda_u246.stopDaemon();
                $this$updateDaemon_u24lambda_u246 = Result.constructor-impl((Object)Unit.INSTANCE);
            }
            catch (Throwable bl) {
                $this$updateDaemon_u24lambda_u246 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
            }
            virusScanDaemonRunner = $this$updateDaemon_u24lambda_u246;
            if (Result.isSuccess-impl((Object)virusScanDaemonRunner)) {
                Unit it = (Unit)virusScanDaemonRunner;
                boolean bl = false;
                this.logger.info("Virus Scan Daemon has been stopped");
            }
            Throwable throwable = Result.exceptionOrNull-impl((Object)virusScanDaemonRunner);
            if (throwable != null) {
                Throwable throwable2;
                Throwable it = throwable2 = throwable;
                boolean bl = false;
                this.logger.error("Error while stopping Virus Scan Daemon", it);
            }
        } else {
            this.logger.info("Virus Scan Daemon already " + (running ? "running" : "stopped"));
            this.publishAntivirusAvailability(running);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void startDaemon() {
        void $this$startDaemon_u24lambda_u2411;
        boolean bl;
        Iterable $this$any$iv;
        block10: {
            Object[] objectArray = new String[]{"dev", "test"};
            $this$any$iv = CollectionsKt.listOf((Object[])objectArray);
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    String it = (String)element$iv;
                    boolean bl2 = false;
                    String[] stringArray = this.getEnvironment().getActiveProfiles();
                    Intrinsics.checkNotNullExpressionValue((Object)stringArray, (String)"getActiveProfiles(...)");
                    if (!ArraysKt.contains((Object[])stringArray, (Object)it)) continue;
                    bl = true;
                    break block10;
                }
                bl = false;
            }
        }
        if (bl) {
            FileUtilsKt.ensureDirectoryExists((Path)this.getConfig().getCacheDirPath());
            FileUtilsKt.ensureDirectoryExists((Path)this.getConfig().getVirusScan().getLogDirPath());
            Path path = this.getConfig().getVirusScan().getDatabaseDirPath();
            if (path != null) {
                Path it = path;
                boolean bl3 = false;
                FileUtilsKt.ensureDirectoryExists((Path)it);
            }
        }
        this.logger.info("Create Virus Scan Daemon container");
        Iterable $i$f$any = $this$any$iv = CollectionsKt.createListBuilder();
        PodmanConfig podmanConfig = this.getConfig().getPodman().getVirusScan();
        String string = "judo-clamd";
        ContainerManageService containerManageService = this.getContainerManageService();
        boolean bl4 = false;
        Object[] bl3 = new String[]{"--user", "clamav", "--entrypoint", "/init-unprivileged", "--health-cmd", this.getConfig().getVirusScan().getHealthCommand(), "--userns", "keep-id:uid=1000,gid=1000", "-v", this.getConfig().getVirusScan().getClamdConfFilePath() + ":/etc/clamav/clamd.conf:ro", "-v", this.getConfig().getVirusScan().getFreshclamConfFilePath() + ":/etc/clamav/freshclam.conf:ro", "-v", this.getConfig().getCacheDirPath() + ":/scandir:ro", "-v", this.getConfig().getVirusScan().getLogDirPath() + ":/var/log/clamav", "--env", "TZ=" + ZoneId.systemDefault(), "--replace", "--restart", "on-failure"};
        $this$startDaemon_u24lambda_u2411.addAll(CollectionsKt.listOf((Object[])bl3));
        if (this.getConfig().getVirusScan().getFreshclamEnabled()) {
            Path databaseDir = this.getConfig().getVirusScan().getDatabaseDirPath();
            if (databaseDir != null) {
                this.logger.info("Enable freshclam daemon. databaseDir: " + databaseDir);
                Object[] objectArray = new String[]{"-v", databaseDir + ":/var/lib/clamav"};
                $this$startDaemon_u24lambda_u2411.addAll(CollectionsKt.listOf((Object[])objectArray));
            } else {
                this.logger.info("Enable freshclam daemon. Use database inside container");
            }
        } else {
            this.logger.info("Disable freshclam daemon, use database inside container");
            Object[] objectArray = new String[]{"--env", "CLAMAV_NO_FRESHCLAMD=true"};
            $this$startDaemon_u24lambda_u2411.addAll(CollectionsKt.listOf((Object[])objectArray));
        }
        Unit unit = Unit.INSTANCE;
        containerManageService.createContainer-9VgGkz4(string, podmanConfig, CollectionsKt.build((List)$this$any$iv), this.clamavImage, DurationKt.toDuration((int)90, (DurationUnit)DurationUnit.SECONDS));
        this.logger.info("Start Virus Scan Daemon container");
        ContainerManageService.startContainer-HG0u8IE$default((ContainerManageService)this.getContainerManageService(), (String)"judo-clamd", (long)0L, (int)2, null);
        this.logger.info("Container started. Wait until Virus Scan Daemon is ready");
        boolean healthy = this.getContainerManageService().waitUntilHealthy-HG0u8IE("judo-clamd", DurationKt.toDuration((int)10, (DurationUnit)DurationUnit.MINUTES));
        if (!healthy) {
            throw new IllegalStateException("Virus Scan Daemon failed to start within configured timeout. See 'podman logs judo-clamd' for more information.'".toString());
        }
    }

    private void stopDaemon() {
        this.getContainerManageService().stopContainer-HG0u8IE("judo-clamd", DurationKt.toDuration((int)0, (DurationUnit)DurationUnit.SECONDS));
    }

    public void publishAntivirusAvailability(boolean isAvailable) {
        this.getApplicationEventPublisher().publishEvent((Object)new AntivirusAvailabilityChangedEvent(isAvailable, (Object)this));
    }

    protected void doHealthCheck(@NotNull Health.Builder builder) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        boolean shouldBeRunning = this.getSuperopertyConnector().getVirusScannerEnabled();
        boolean isRunning = ContainerManageService.isContainerRunning-HG0u8IE$default((ContainerManageService)this.getContainerManageService(), (String)"judo-clamd", (long)0L, (int)2, null);
        boolean isHealthy = isRunning && ContainerManageService.runHealthcheck-HG0u8IE$default((ContainerManageService)this.getContainerManageService(), (String)"judo-clamd", (long)0L, (int)2, null);
        builder.withDetail("judo-clamd container should be running", (Object)shouldBeRunning);
        builder.withDetail("judo-clamd container is running", (Object)isRunning);
        builder.withDetail("judo-clamd container is healthy", (Object)isHealthy);
        builder.status(shouldBeRunning && !isHealthy ? Status.DOWN : Status.UP);
    }
}

