/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.justdocumentz.monitoring;

import com.google.common.collect.EvictingQueue;
import de.justsoftware.justdocumentz.config.MonitoringConfig;
import de.justsoftware.justdocumentz.monitoring.MonitoringStatus;
import de.justsoftware.justdocumentz.monitoring.ResettableHealthIndicator;
import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.MeterRegistry;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.actuate.health.Health;
import org.springframework.boot.actuate.health.Status;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0012H\u0002J\b\u0010\u001b\u001a\u00020\u0019H\u0004J\b\u0010\u001c\u001a\u00020\u0019H\u0004J\b\u0010\u001d\u001a\u00020\u0019H\u0004J\u0010\u0010\u001e\u001a\u00020\u00192\u0006\u0010\u001f\u001a\u00020 H\u0014J\b\u0010!\u001a\u00020\u0019H\u0016R\u000e\u0010\u000b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u000e\u0010\u0016\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lde/justsoftware/justdocumentz/monitoring/CountingHealthIndicator;", "Lde/justsoftware/justdocumentz/monitoring/ResettableHealthIndicator;", "counterNamePrefix", "", "meterRegistry", "Lio/micrometer/core/instrument/MeterRegistry;", "monitoringConfig", "Lde/justsoftware/justdocumentz/config/MonitoringConfig;", "processingMax", "", "(Ljava/lang/String;Lio/micrometer/core/instrument/MeterRegistry;Lde/justsoftware/justdocumentz/config/MonitoringConfig;I)V", "errorCountThreshold", "errorCounter", "Lio/micrometer/core/instrument/Counter;", "logger", "Lorg/slf4j/Logger;", "monitoringStatusQueue", "Lcom/google/common/collect/EvictingQueue;", "Lde/justsoftware/justdocumentz/monitoring/MonitoringStatus;", "processingCounter", "getProcessingMax", "()I", "statusQueueSize", "totalCounter", "add", "", "status", "addError", "addOk", "addProcessing", "doHealthCheck", "builder", "Lorg/springframework/boot/actuate/health/Health$Builder;", "resetStatus", "just-documentz"})
@SourceDebugExtension(value={"SMAP\nCountingHealthIndicator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CountingHealthIndicator.kt\nde/justsoftware/justdocumentz/monitoring/CountingHealthIndicator\n+ 2 LoggerExtensions.kt\nde/justsoftware/justdocumentz/util/LoggerExtensionsKt\n*L\n1#1,83:1\n9#2:84\n*S KotlinDebug\n*F\n+ 1 CountingHealthIndicator.kt\nde/justsoftware/justdocumentz/monitoring/CountingHealthIndicator\n*L\n22#1:84\n*E\n"})
public abstract class CountingHealthIndicator
extends ResettableHealthIndicator {
    private final int processingMax;
    @NotNull
    private final Logger logger;
    private final int statusQueueSize;
    private final int errorCountThreshold;
    @NotNull
    private final Counter processingCounter;
    @NotNull
    private final Counter totalCounter;
    @NotNull
    private final Counter errorCounter;
    @NotNull
    private final EvictingQueue<MonitoringStatus> monitoringStatusQueue;

    public CountingHealthIndicator(@NotNull String counterNamePrefix, @NotNull MeterRegistry meterRegistry, @NotNull MonitoringConfig monitoringConfig, int processingMax) {
        Intrinsics.checkNotNullParameter((Object)counterNamePrefix, (String)"counterNamePrefix");
        Intrinsics.checkNotNullParameter((Object)meterRegistry, (String)"meterRegistry");
        Intrinsics.checkNotNullParameter((Object)monitoringConfig, (String)"monitoringConfig");
        this.processingMax = processingMax;
        CountingHealthIndicator $this$logger$iv = this;
        boolean $i$f$logger = false;
        Logger logger = LoggerFactory.getLogger(CountingHealthIndicator.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        this.logger = logger;
        this.statusQueueSize = monitoringConfig.getQueueSize();
        this.errorCountThreshold = monitoringConfig.getErrorThreshold();
        Counter counter = meterRegistry.counter(counterNamePrefix + ".processing", new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)counter, (String)"counter(...)");
        this.processingCounter = counter;
        Counter counter2 = meterRegistry.counter(counterNamePrefix + ".total", new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)counter2, (String)"counter(...)");
        this.totalCounter = counter2;
        Counter counter3 = meterRegistry.counter(counterNamePrefix + ".error", new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)counter3, (String)"counter(...)");
        this.errorCounter = counter3;
        EvictingQueue evictingQueue = EvictingQueue.create((int)this.statusQueueSize);
        Intrinsics.checkNotNullExpressionValue((Object)evictingQueue, (String)"create(...)");
        this.monitoringStatusQueue = evictingQueue;
    }

    public final int getProcessingMax() {
        return this.processingMax;
    }

    protected final synchronized void addProcessing() {
        this.processingCounter.increment();
    }

    protected final synchronized void addOk() {
        this.add(MonitoringStatus.OK);
    }

    protected final synchronized void addError() {
        this.add(MonitoringStatus.ERROR);
    }

    private final void add(MonitoringStatus status) {
        this.monitoringStatusQueue.add((Object)status);
        this.totalCounter.increment();
        if (status == MonitoringStatus.ERROR) {
            this.errorCounter.increment();
        }
    }

    protected synchronized void doHealthCheck(@NotNull Health.Builder builder) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        long errorCount = this.monitoringStatusQueue.stream().filter(arg_0 -> MonitoringStatus.ERROR.equals(arg_0)).count();
        builder.withDetail("monitoring state error/ok", (Object)(errorCount + "/" + this.monitoringStatusQueue.size()));
        builder.withDetail("processing current/maximum", (Object)(this.processingCounter.count() - this.totalCounter.count() + "/" + this.processingMax));
        builder.withDetail("error threshold", (Object)(this.errorCountThreshold + " out of " + this.statusQueueSize));
        builder.withDetail("errors since startup", (Object)this.errorCounter.count());
        builder.withDetail("total since startup", (Object)this.totalCounter.count());
        builder.status(errorCount >= (long)this.errorCountThreshold ? Status.DOWN : Status.UP);
    }

    public synchronized void resetStatus() {
        this.logger.info("resetting monitoringStatusQueue by clearing entries");
        this.monitoringStatusQueue.clear();
    }
}

