/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.justdocumentz.common;

import de.justsoftware.justdocumentz.common.ContainerManageService;
import de.justsoftware.justdocumentz.config.PodmanConfig;
import de.justsoftware.justdocumentz.util.CommandLineResult;
import de.justsoftware.justdocumentz.util.CommandLineUtilsKt;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlin.time.Duration;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 * Exception performing whole class analysis ignored.
 */
@Service
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\b\b\u0017\u0018\u0000  2\u00020\u0001:\u0001 B\u0005\u00a2\u0006\u0002\u0010\u0002JB\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\b0\f2\u0006\u0010\r\u001a\u00020\b2\b\b\u0002\u0010\u000e\u001a\u00020\u000fH\u0016\u00f8\u0001\u0000\u00a2\u0006\u0004\b\u0010\u0010\u0011J$\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0007\u001a\u00020\b2\b\b\u0002\u0010\u000e\u001a\u00020\u000fH\u0016\u00f8\u0001\u0000\u00a2\u0006\u0004\b\u0014\u0010\u0015J$\u0010\u0016\u001a\u00020\u00132\u0006\u0010\u0007\u001a\u00020\b2\b\b\u0002\u0010\u000e\u001a\u00020\u000fH\u0016\u00f8\u0001\u0000\u00a2\u0006\u0004\b\u0017\u0010\u0015J$\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0007\u001a\u00020\b2\b\b\u0002\u0010\u000e\u001a\u00020\u000fH\u0016\u00f8\u0001\u0000\u00a2\u0006\u0004\b\u001a\u0010\u001bJ$\u0010\u001c\u001a\u00020\u00192\u0006\u0010\u0007\u001a\u00020\b2\b\b\u0002\u0010\u000e\u001a\u00020\u000fH\u0016\u00f8\u0001\u0000\u00a2\u0006\u0004\b\u001d\u0010\u001bJ\"\u0010\u001e\u001a\u00020\u00132\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016\u00f8\u0001\u0000\u00a2\u0006\u0004\b\u001f\u0010\u0015R\u000e\u0010\u0003\u001a\u00020\u0004X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0007\n\u0005\b\u00a1\u001e0\u0001\u00a8\u0006!"}, d2={"Lde/justsoftware/justdocumentz/common/ContainerManageService;", "", "()V", "logger", "Lorg/slf4j/Logger;", "createContainer", "", "containerName", "", "podmanConfig", "Lde/justsoftware/justdocumentz/config/PodmanConfig;", "arguments", "", "imageName", "timeout", "Lkotlin/time/Duration;", "createContainer-9VgGkz4", "(Ljava/lang/String;Lde/justsoftware/justdocumentz/config/PodmanConfig;Ljava/util/List;Ljava/lang/String;J)V", "isContainerRunning", "", "isContainerRunning-HG0u8IE", "(Ljava/lang/String;J)Z", "runHealthcheck", "runHealthcheck-HG0u8IE", "startContainer", "Lde/justsoftware/justdocumentz/util/CommandLineResult;", "startContainer-HG0u8IE", "(Ljava/lang/String;J)Lde/justsoftware/justdocumentz/util/CommandLineResult;", "stopContainer", "stopContainer-HG0u8IE", "waitUntilHealthy", "waitUntilHealthy-HG0u8IE", "Companion", "just-documentz"})
@SourceDebugExtension(value={"SMAP\nContainerManageService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ContainerManageService.kt\nde/justsoftware/justdocumentz/common/ContainerManageService\n+ 2 LoggerExtensions.kt\nde/justsoftware/justdocumentz/util/LoggerExtensionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,115:1\n9#2:116\n1#3:117\n*S KotlinDebug\n*F\n+ 1 ContainerManageService.kt\nde/justsoftware/justdocumentz/common/ContainerManageService\n*L\n23#1:116\n*E\n"})
public class ContainerManageService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Logger logger;
    private static final long DEFAULT_TIMEOUT = DurationKt.toDuration((int)30, (DurationUnit)DurationUnit.SECONDS);

    public ContainerManageService() {
        ContainerManageService $this$logger$iv = this;
        boolean $i$f$logger = false;
        Logger logger = LoggerFactory.getLogger(ContainerManageService.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        this.logger = logger;
    }

    public boolean isContainerRunning-HG0u8IE(@NotNull String containerName, long timeout) {
        Intrinsics.checkNotNullParameter((Object)containerName, (String)"containerName");
        Object[] objectArray = new String[]{"podman", "ps", "--filter", "name=" + containerName, "--format", "{{.Names}}"};
        List command = CollectionsKt.listOf((Object[])objectArray);
        CommandLineResult result = CommandLineUtilsKt.executeCommandLine-hhJSO8g$default((List)command, (Duration)Duration.box-impl((long)timeout), (boolean)false, null, (int)12, null);
        return Intrinsics.areEqual((Object)((Object)StringsKt.trim((CharSequence)result.getOutput())).toString(), (Object)containerName);
    }

    public static /* synthetic */ boolean isContainerRunning-HG0u8IE$default(ContainerManageService containerManageService, String string, long l, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: isContainerRunning-HG0u8IE");
        }
        if ((n & 2) != 0) {
            l = DEFAULT_TIMEOUT;
        }
        return containerManageService.isContainerRunning-HG0u8IE(string, l);
    }

    public void createContainer-9VgGkz4(@NotNull String containerName, @NotNull PodmanConfig podmanConfig, @NotNull List<String> arguments, @NotNull String imageName, long timeout) {
        List list;
        Intrinsics.checkNotNullParameter((Object)containerName, (String)"containerName");
        Intrinsics.checkNotNullParameter((Object)podmanConfig, (String)"podmanConfig");
        Intrinsics.checkNotNullParameter(arguments, (String)"arguments");
        Intrinsics.checkNotNullParameter((Object)imageName, (String)"imageName");
        List $this$createContainer_9VgGkz4_u24lambda_u240 = list = CollectionsKt.createListBuilder();
        boolean bl = false;
        Object[] objectArray = new String[]{"podman", "create", "--name", containerName, "--pull", "never"};
        $this$createContainer_9VgGkz4_u24lambda_u240.addAll(CollectionsKt.listOf((Object[])objectArray));
        $this$createContainer_9VgGkz4_u24lambda_u240.addAll(CommandLineUtilsKt.toArgs((PodmanConfig)podmanConfig));
        $this$createContainer_9VgGkz4_u24lambda_u240.addAll((Collection)arguments);
        $this$createContainer_9VgGkz4_u24lambda_u240.add(imageName);
        CommandLineUtilsKt.executeCommandLine-hhJSO8g$default((List)CollectionsKt.build((List)list), (Duration)Duration.box-impl((long)timeout), (boolean)false, null, (int)12, null);
    }

    public static /* synthetic */ void createContainer-9VgGkz4$default(ContainerManageService containerManageService, String string, PodmanConfig podmanConfig, List list, String string2, long l, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: createContainer-9VgGkz4");
        }
        if ((n & 0x10) != 0) {
            l = DEFAULT_TIMEOUT;
        }
        containerManageService.createContainer-9VgGkz4(string, podmanConfig, list, string2, l);
    }

    @NotNull
    public CommandLineResult startContainer-HG0u8IE(@NotNull String containerName, long timeout) {
        Intrinsics.checkNotNullParameter((Object)containerName, (String)"containerName");
        Object[] objectArray = new String[]{"podman", "start", containerName};
        return CommandLineUtilsKt.executeCommandLine-hhJSO8g$default((List)CollectionsKt.listOf((Object[])objectArray), (Duration)Duration.box-impl((long)timeout), (boolean)false, null, (int)12, null);
    }

    public static /* synthetic */ CommandLineResult startContainer-HG0u8IE$default(ContainerManageService containerManageService, String string, long l, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: startContainer-HG0u8IE");
        }
        if ((n & 2) != 0) {
            l = DEFAULT_TIMEOUT;
        }
        return containerManageService.startContainer-HG0u8IE(string, l);
    }

    @NotNull
    public CommandLineResult stopContainer-HG0u8IE(@NotNull String containerName, long timeout) {
        Intrinsics.checkNotNullParameter((Object)containerName, (String)"containerName");
        Object[] objectArray = new String[]{"podman", "stop", "--time", String.valueOf(Duration.getInWholeSeconds-impl((long)timeout)), containerName};
        return CommandLineUtilsKt.executeCommandLine-hhJSO8g$default((List)CollectionsKt.listOf((Object[])objectArray), (Duration)Duration.box-impl((long)Duration.plus-LRDsOJo((long)timeout, (long)DurationKt.toDuration((int)5, (DurationUnit)DurationUnit.SECONDS))), (boolean)false, null, (int)12, null);
    }

    public static /* synthetic */ CommandLineResult stopContainer-HG0u8IE$default(ContainerManageService containerManageService, String string, long l, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: stopContainer-HG0u8IE");
        }
        if ((n & 2) != 0) {
            l = DEFAULT_TIMEOUT;
        }
        return containerManageService.stopContainer-HG0u8IE(string, l);
    }

    public boolean runHealthcheck-HG0u8IE(@NotNull String containerName, long timeout) {
        Object object;
        Object $this$runHealthcheck_HG0u8IE_u24lambda_u241;
        Intrinsics.checkNotNullParameter((Object)containerName, (String)"containerName");
        ContainerManageService containerManageService = this;
        try {
            $this$runHealthcheck_HG0u8IE_u24lambda_u241 = containerManageService;
            boolean bl = false;
            Object[] objectArray = new String[]{"podman", "healthcheck", "run", containerName};
            List list = CollectionsKt.listOf((Object[])objectArray);
            objectArray = new Integer[]{0, 1};
            CommandLineResult result = CommandLineUtilsKt.executeCommandLine-hhJSO8g$default((List)list, (Duration)Duration.box-impl((long)timeout), (boolean)false, (Collection)SetsKt.setOf((Object[])objectArray), (int)4, null);
            $this$runHealthcheck_HG0u8IE_u24lambda_u241 = Result.constructor-impl((Object)(result.getExitCode() == 0 ? 1 : 0));
        }
        catch (Throwable bl) {
            $this$runHealthcheck_HG0u8IE_u24lambda_u241 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
        }
        containerManageService = $this$runHealthcheck_HG0u8IE_u24lambda_u241;
        Throwable throwable = Result.exceptionOrNull-impl((Object)containerManageService);
        if (throwable != null) {
            Object it = $this$runHealthcheck_HG0u8IE_u24lambda_u241 = throwable;
            boolean bl = false;
            this.logger.warn("Error while running healthcheck for container " + containerName + ". message: " + ((Throwable)it).getMessage());
        }
        Throwable throwable2 = Result.exceptionOrNull-impl((Object)containerManageService);
        if (throwable2 == null) {
            object = containerManageService;
        } else {
            Throwable it = throwable2;
            boolean bl = false;
            object = false;
        }
        return (Boolean)object;
    }

    public static /* synthetic */ boolean runHealthcheck-HG0u8IE$default(ContainerManageService containerManageService, String string, long l, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: runHealthcheck-HG0u8IE");
        }
        if ((n & 2) != 0) {
            l = DEFAULT_TIMEOUT;
        }
        return containerManageService.runHealthcheck-HG0u8IE(string, l);
    }

    public boolean waitUntilHealthy-HG0u8IE(@NotNull String containerName, long timeout) {
        Intrinsics.checkNotNullParameter((Object)containerName, (String)"containerName");
        Instant deadline = Instant.now().plus(Duration.getInWholeMilliseconds-impl((long)timeout), ChronoUnit.MILLIS);
        boolean healthy = false;
        do {
            Thread.sleep(1000L);
        } while (!(healthy = ContainerManageService.runHealthcheck-HG0u8IE$default((ContainerManageService)this, (String)containerName, (long)0L, (int)2, null)) && Instant.now().isBefore(deadline));
        return healthy;
    }
}

