/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.justdocumentz.api;

import de.justsoftware.justdocumentz.api.VirusScanTask;
import de.justsoftware.justdocumentz.config.JudoConfig;
import de.justsoftware.justdocumentz.config.KafkaConfig;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.kafka.config.ConcurrentKafkaListenerContainerFactory;
import org.springframework.kafka.core.ConsumerFactory;
import org.springframework.kafka.listener.ContainerProperties;

@Configuration
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0014\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\bH\u0017J\u0014\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\fH\u0017R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lde/justsoftware/justdocumentz/api/VirusScanTaskKafkaConfig;", "", "judoConfig", "Lde/justsoftware/justdocumentz/config/JudoConfig;", "kafkaConfig", "Lde/justsoftware/justdocumentz/config/KafkaConfig;", "(Lde/justsoftware/justdocumentz/config/JudoConfig;Lde/justsoftware/justdocumentz/config/KafkaConfig;)V", "kafkaVirusScanTaskListenerContainerFactory", "Lorg/springframework/kafka/config/ConcurrentKafkaListenerContainerFactory;", "", "Lde/justsoftware/justdocumentz/api/VirusScanTask;", "virusTaskConsumerFactory", "Lorg/springframework/kafka/core/ConsumerFactory;", "just-documentz"})
public class VirusScanTaskKafkaConfig {
    @NotNull
    private final JudoConfig judoConfig;
    @NotNull
    private final KafkaConfig kafkaConfig;

    public VirusScanTaskKafkaConfig(@NotNull JudoConfig judoConfig, @NotNull KafkaConfig kafkaConfig) {
        Intrinsics.checkNotNullParameter((Object)judoConfig, (String)"judoConfig");
        Intrinsics.checkNotNullParameter((Object)kafkaConfig, (String)"kafkaConfig");
        this.judoConfig = judoConfig;
        this.kafkaConfig = kafkaConfig;
    }

    @Bean
    @NotNull
    public ConsumerFactory<String, VirusScanTask> virusTaskConsumerFactory() {
        return KafkaConfig.createLongRunningConsumerFactory$default((KafkaConfig)this.kafkaConfig, VirusScanTask.class, (String)"virus-scan-task-group", null, (int)4, null);
    }

    @Bean
    @NotNull
    public ConcurrentKafkaListenerContainerFactory<String, VirusScanTask> kafkaVirusScanTaskListenerContainerFactory() {
        ConcurrentKafkaListenerContainerFactory factory = new ConcurrentKafkaListenerContainerFactory();
        factory.setConsumerFactory(this.virusTaskConsumerFactory());
        factory.setConcurrency(Integer.valueOf(this.judoConfig.getVirusScan().getConcurrency()));
        factory.getContainerProperties().setAckMode(ContainerProperties.AckMode.RECORD);
        return factory;
    }
}

