/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.justdocumentz.api;

import de.justsoftware.justdocumentz.api.KafkaVirusScanTaskListener;
import de.justsoftware.justdocumentz.api.VirusScanTask;
import de.justsoftware.justdocumentz.events.AntivirusAvailabilityChangedEvent;
import de.justsoftware.justdocumentz.virusscan.VirusScanJobRunner;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.event.EventListener;
import org.springframework.kafka.annotation.KafkaListener;
import org.springframework.kafka.config.KafkaListenerEndpointRegistry;
import org.springframework.kafka.listener.MessageListenerContainer;
import org.springframework.messaging.handler.annotation.Header;
import org.springframework.messaging.handler.annotation.Payload;
import org.springframework.stereotype.Component;

@Component
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0017\u0018\u0000 \u00162\u00020\u0001:\u0001\u0016B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u001c\u0010\u000b\u001a\u00020\f2\b\b\u0001\u0010\r\u001a\u00020\u000e2\b\b\u0001\u0010\u000f\u001a\u00020\u0010H\u0017J\u0010\u0010\u0011\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\u0013H\u0017J\b\u0010\u0014\u001a\u00020\fH\u0016J\b\u0010\u0015\u001a\u00020\fH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0017"}, d2={"Lde/justsoftware/justdocumentz/api/KafkaVirusScanTaskListener;", "", "virusScanJobRunner", "Lde/justsoftware/justdocumentz/virusscan/VirusScanJobRunner;", "kafkaListenerEndpointRegistry", "Lorg/springframework/kafka/config/KafkaListenerEndpointRegistry;", "(Lde/justsoftware/justdocumentz/virusscan/VirusScanJobRunner;Lorg/springframework/kafka/config/KafkaListenerEndpointRegistry;)V", "logger", "Lorg/slf4j/Logger;", "getVirusScanJobRunner", "()Lde/justsoftware/justdocumentz/virusscan/VirusScanJobRunner;", "listen", "", "key", "", "task", "Lde/justsoftware/justdocumentz/api/VirusScanTask;", "onAntivirusAvailabilityChanged", "event", "Lde/justsoftware/justdocumentz/events/AntivirusAvailabilityChangedEvent;", "startListening", "stopListening", "Companion", "just-documentz"})
@SourceDebugExtension(value={"SMAP\nVirusScanKafkaListener.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VirusScanKafkaListener.kt\nde/justsoftware/justdocumentz/api/KafkaVirusScanTaskListener\n+ 2 LoggerExtensions.kt\nde/justsoftware/justdocumentz/util/LoggerExtensionsKt\n*L\n1#1,146:1\n9#2:147\n*S KotlinDebug\n*F\n+ 1 VirusScanKafkaListener.kt\nde/justsoftware/justdocumentz/api/KafkaVirusScanTaskListener\n*L\n74#1:147\n*E\n"})
public class KafkaVirusScanTaskListener {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final VirusScanJobRunner virusScanJobRunner;
    @NotNull
    private final KafkaListenerEndpointRegistry kafkaListenerEndpointRegistry;
    @NotNull
    private final Logger logger;
    @NotNull
    public static final String LISTENER_ID = "virus_scan_listener";

    public KafkaVirusScanTaskListener(@NotNull VirusScanJobRunner virusScanJobRunner, @NotNull KafkaListenerEndpointRegistry kafkaListenerEndpointRegistry) {
        Intrinsics.checkNotNullParameter((Object)virusScanJobRunner, (String)"virusScanJobRunner");
        Intrinsics.checkNotNullParameter((Object)kafkaListenerEndpointRegistry, (String)"kafkaListenerEndpointRegistry");
        this.virusScanJobRunner = virusScanJobRunner;
        this.kafkaListenerEndpointRegistry = kafkaListenerEndpointRegistry;
        KafkaVirusScanTaskListener $this$logger$iv = this;
        boolean $i$f$logger = false;
        Logger logger = LoggerFactory.getLogger(KafkaVirusScanTaskListener.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        this.logger = logger;
    }

    @NotNull
    public VirusScanJobRunner getVirusScanJobRunner() {
        return this.virusScanJobRunner;
    }

    @KafkaListener(id="virus_scan_listener", containerFactory="kafkaVirusScanTaskListenerContainerFactory", topics={"just.virus.scan"}, autoStartup="false")
    public void listen(@Header(value="kafka_receivedMessageKey") @NotNull String key, @Payload @NotNull VirusScanTask task) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        this.logger.info("Received virus scan task for task: " + key);
        VirusScanJobRunner virusScanJobRunner = this.getVirusScanJobRunner();
        String string = task.getStorageId();
        if (string == null) {
            string = key;
        }
        virusScanJobRunner.scanForVirus(string, task.getRemoteUrl());
    }

    public void startListening() {
        MessageListenerContainer messageListenerContainer = this.kafkaListenerEndpointRegistry.getListenerContainer(LISTENER_ID);
        if (messageListenerContainer != null) {
            messageListenerContainer.start();
        }
        this.logger.info("Started Kafka listener for virus scan tasks");
    }

    public void stopListening() {
        MessageListenerContainer messageListenerContainer = this.kafkaListenerEndpointRegistry.getListenerContainer(LISTENER_ID);
        if (messageListenerContainer != null) {
            messageListenerContainer.stop();
        }
        this.logger.info("Stopped Kafka listener for virus scan tasks");
    }

    @EventListener
    public void onAntivirusAvailabilityChanged(@NotNull AntivirusAvailabilityChangedEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (event.isAvailable()) {
            this.startListening();
        } else {
            this.stopListening();
        }
    }
}

