/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.justdocumentz.api;

import de.justsoftware.justdocumentz.api.DocumentViewService;
import java.net.URLConnection;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.springframework.core.io.Resource;
import org.springframework.http.HttpHeaders;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;

@Controller
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0017\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\b\b\u0001\u0010\n\u001a\u00020\u000bH\u0017J,\u0010\f\u001a\b\u0012\u0004\u0012\u00020\t0\b2\b\b\u0001\u0010\n\u001a\u00020\u000b2\b\b\u0001\u0010\r\u001a\u00020\u000e2\b\b\u0001\u0010\u000f\u001a\u00020\u000eH\u0017J\u0018\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\t0\b2\b\b\u0001\u0010\n\u001a\u00020\u000bH\u0017J\u0012\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\t0\b*\u00020\tH\u0012R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0012"}, d2={"Lde/justsoftware/justdocumentz/api/DocumentViewController;", "", "documentViewService", "Lde/justsoftware/justdocumentz/api/DocumentViewService;", "(Lde/justsoftware/justdocumentz/api/DocumentViewService;)V", "getDocumentViewService", "()Lde/justsoftware/justdocumentz/api/DocumentViewService;", "fetchConvertedVideo", "Lorg/springframework/http/ResponseEntity;", "Lorg/springframework/core/io/Resource;", "documentId", "Ljava/util/UUID;", "fetchResources", "contentType", "", "contentResource", "fetchVideoCover", "toResponseEntity", "just-documentz"})
@SourceDebugExtension(value={"SMAP\nDocumentViewController.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DocumentViewController.kt\nde/justsoftware/justdocumentz/api/DocumentViewController\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,96:1\n1#2:97\n*E\n"})
public class DocumentViewController {
    @NotNull
    private final DocumentViewService documentViewService;

    public DocumentViewController(@NotNull DocumentViewService documentViewService) {
        Intrinsics.checkNotNullParameter((Object)documentViewService, (String)"documentViewService");
        this.documentViewService = documentViewService;
    }

    @NotNull
    public DocumentViewService getDocumentViewService() {
        return this.documentViewService;
    }

    @RequestMapping(value={"/content/{documentId}/{documentType}/{resourceName:.*}"}, produces={"*/*"})
    @NotNull
    public ResponseEntity<Resource> fetchResources(@PathVariable(value="documentId") @NotNull UUID documentId, @PathVariable(value="documentType") @NotNull String contentType, @PathVariable(value="resourceName") @NotNull String contentResource) {
        Intrinsics.checkNotNullParameter((Object)documentId, (String)"documentId");
        Intrinsics.checkNotNullParameter((Object)contentType, (String)"contentType");
        Intrinsics.checkNotNullParameter((Object)contentResource, (String)"contentResource");
        if (!Intrinsics.areEqual((Object)contentType, (Object)"HTML")) {
            boolean bl = false;
            String string = "Only HTML preview is supported.";
            throw new IllegalArgumentException(string.toString());
        }
        return this.toResponseEntity(this.getDocumentViewService().getDocumentPreviewResource(documentId, contentResource));
    }

    @RequestMapping(value={"/conversions/{previewId:.*}.converted.mp4"}, produces={"application/octet-stream"})
    @NotNull
    public ResponseEntity<Resource> fetchConvertedVideo(@PathVariable(value="previewId") @NotNull UUID documentId) {
        Intrinsics.checkNotNullParameter((Object)documentId, (String)"documentId");
        return this.toResponseEntity(this.getDocumentViewService().getConvertedVideo(documentId));
    }

    @RequestMapping(value={"/conversions/{previewId:.*}.converted_cover.png"}, produces={"*/*"})
    @NotNull
    public ResponseEntity<Resource> fetchVideoCover(@PathVariable(value="previewId") @NotNull UUID documentId) {
        Intrinsics.checkNotNullParameter((Object)documentId, (String)"documentId");
        return this.toResponseEntity(this.getDocumentViewService().getCoverImage(documentId));
    }

    private ResponseEntity<Resource> toResponseEntity(Resource $this$toResponseEntity) {
        ResponseEntity responseEntity;
        if ($this$toResponseEntity.exists()) {
            ResponseEntity responseEntity2 = ((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(arg_0 -> DocumentViewController.toResponseEntity$lambda$1($this$toResponseEntity, arg_0))).body((Object)$this$toResponseEntity);
            Intrinsics.checkNotNull((Object)responseEntity2);
            responseEntity = responseEntity2;
        } else {
            ResponseEntity responseEntity3 = ResponseEntity.notFound().build();
            Intrinsics.checkNotNull((Object)responseEntity3);
            responseEntity = responseEntity3;
        }
        return responseEntity;
    }

    private static final void toResponseEntity$lambda$1(Resource $this_toResponseEntity, HttpHeaders headers) {
        Intrinsics.checkNotNullParameter((Object)$this_toResponseEntity, (String)"$this_toResponseEntity");
        headers.set("content-type", URLConnection.guessContentTypeFromName($this_toResponseEntity.getFilename()));
        headers.setContentLength($this_toResponseEntity.contentLength());
    }
}

