/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.justdocumentz.api;

import de.justsoftware.justdocumentz.api.DocumentApiService;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.kafka.annotation.KafkaListener;
import org.springframework.messaging.handler.annotation.Header;
import org.springframework.stereotype.Component;

@Component
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0012\u0010\u000b\u001a\u00020\f2\b\b\u0001\u0010\r\u001a\u00020\u000eH\u0017R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000f"}, d2={"Lde/justsoftware/justdocumentz/api/DocumentPreviewDeletionListener;", "", "apiService", "Lde/justsoftware/justdocumentz/api/DocumentApiService;", "(Lde/justsoftware/justdocumentz/api/DocumentApiService;)V", "getApiService", "()Lde/justsoftware/justdocumentz/api/DocumentApiService;", "log", "Lorg/slf4j/Logger;", "getLog", "()Lorg/slf4j/Logger;", "listen", "", "previewId", "", "just-documentz"})
@SourceDebugExtension(value={"SMAP\nDocumentPreviewDeletionListener.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DocumentPreviewDeletionListener.kt\nde/justsoftware/justdocumentz/api/DocumentPreviewDeletionListener\n+ 2 LoggerExtensions.kt\nde/justsoftware/justdocumentz/util/LoggerExtensionsKt\n*L\n1#1,31:1\n9#2:32\n*S KotlinDebug\n*F\n+ 1 DocumentPreviewDeletionListener.kt\nde/justsoftware/justdocumentz/api/DocumentPreviewDeletionListener\n*L\n13#1:32\n*E\n"})
public class DocumentPreviewDeletionListener {
    @NotNull
    private final DocumentApiService apiService;
    @NotNull
    private final Logger log;

    public DocumentPreviewDeletionListener(@NotNull DocumentApiService apiService) {
        Intrinsics.checkNotNullParameter((Object)apiService, (String)"apiService");
        this.apiService = apiService;
        DocumentPreviewDeletionListener $this$logger$iv = this;
        boolean $i$f$logger = false;
        Logger logger = LoggerFactory.getLogger(DocumentPreviewDeletionListener.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        this.log = logger;
    }

    @NotNull
    public DocumentApiService getApiService() {
        return this.apiService;
    }

    @NotNull
    public Logger getLog() {
        return this.log;
    }

    @KafkaListener(topics={"just.documents.preview.deletion"}, groupId="just.documents.preview.deletion-group-id")
    public void listen(@Header(value="kafka_receivedMessageKey") @NotNull String previewId) {
        UUID uUID;
        Intrinsics.checkNotNullParameter((Object)previewId, (String)"previewId");
        try {
            uUID = UUID.fromString(previewId);
        }
        catch (IllegalArgumentException e) {
            this.getLog().error("Skipping message with invalid UUID key: " + previewId, (Throwable)e);
            return;
        }
        UUID uuid = uUID;
        this.getLog().info("Deleting preview for " + uuid);
        this.getApiService().deleteAll(CollectionsKt.listOf((Object)uuid));
    }
}

