/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.chat.persistence.model;

import de.justsoftware.chat.model.ProfileId;
import de.justsoftware.chat.model.UserGroupId;
import de.justsoftware.chat.model.UserGroupMemberId;
import de.justsoftware.chat.persistence.model.DbAuditModel;
import de.justsoftware.chat.persistence.model.DbUserGroupMember;
import de.justsoftware.chat.persistence.model.DbUserGroupMemberId;
import jakarta.persistence.Entity;
import jakarta.persistence.Id;
import jakarta.persistence.IdClass;
import jakarta.persistence.Table;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Entity
@Table(name="UserGroupMember")
@IdClass(value=DbUserGroupMemberId.class)
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\b\u0087\b\u0018\u0000 \u001a2\u00020\u0001:\u0001\u001aB\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006B\u0019\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0007\u0012\u0006\u0010\u0004\u001a\u00020\b\u00a2\u0006\u0004\b\u0005\u0010\tB\u0011\b\u0016\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0004\b\u0005\u0010\fJ\t\u0010\u0010\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\u0012\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u00d6\u0003J\t\u0010\u0017\u001a\u00020\u0018H\u00d6\u0001J\t\u0010\u0019\u001a\u00020\u0003H\u00d6\u0001R\u0016\u0010\u0002\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0016\u0010\u0004\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u000e\u00a8\u0006\u001b"}, d2={"Lde/justsoftware/chat/persistence/model/DbUserGroupMember;", "Lde/justsoftware/chat/persistence/model/DbAuditModel;", "groupId", "", "profileId", "<init>", "(Ljava/lang/String;Ljava/lang/String;)V", "Lde/justsoftware/chat/model/UserGroupId;", "Lde/justsoftware/chat/model/ProfileId;", "(Lde/justsoftware/chat/model/UserGroupId;Lde/justsoftware/chat/model/ProfileId;)V", "id", "Lde/justsoftware/chat/model/UserGroupMemberId;", "(Lde/justsoftware/chat/model/UserGroupMemberId;)V", "getGroupId", "()Ljava/lang/String;", "getProfileId", "component1", "component2", "copy", "equals", "", "other", "", "hashCode", "", "toString", "Companion", "chat-service"})
public final class DbUserGroupMember
extends DbAuditModel {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Id
    @NotNull
    private final String groupId;
    @Id
    @NotNull
    private final String profileId;

    public DbUserGroupMember(@NotNull String groupId, @NotNull String profileId) {
        Intrinsics.checkNotNullParameter((Object)groupId, (String)"groupId");
        Intrinsics.checkNotNullParameter((Object)profileId, (String)"profileId");
        this.groupId = groupId;
        this.profileId = profileId;
    }

    @NotNull
    public final String getGroupId() {
        return this.groupId;
    }

    @NotNull
    public final String getProfileId() {
        return this.profileId;
    }

    public DbUserGroupMember(@NotNull UserGroupId groupId, @NotNull ProfileId profileId) {
        Intrinsics.checkNotNullParameter((Object)groupId, (String)"groupId");
        Intrinsics.checkNotNullParameter((Object)profileId, (String)"profileId");
        this(groupId.toCanonicalId(), profileId.toCanonicalId());
    }

    public DbUserGroupMember(@NotNull UserGroupMemberId id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        this(id.getGroupId(), id.getProfileId());
    }

    @NotNull
    public final String component1() {
        return this.groupId;
    }

    @NotNull
    public final String component2() {
        return this.profileId;
    }

    @NotNull
    public final DbUserGroupMember copy(@NotNull String groupId, @NotNull String profileId) {
        Intrinsics.checkNotNullParameter((Object)groupId, (String)"groupId");
        Intrinsics.checkNotNullParameter((Object)profileId, (String)"profileId");
        return new DbUserGroupMember(groupId, profileId);
    }

    public static /* synthetic */ DbUserGroupMember copy$default(DbUserGroupMember dbUserGroupMember, String string, String string2, int n, Object object) {
        if ((n & 1) != 0) {
            string = dbUserGroupMember.groupId;
        }
        if ((n & 2) != 0) {
            string2 = dbUserGroupMember.profileId;
        }
        return dbUserGroupMember.copy(string, string2);
    }

    @NotNull
    public String toString() {
        return "DbUserGroupMember(groupId=" + this.groupId + ", profileId=" + this.profileId + ")";
    }

    public int hashCode() {
        int result = this.groupId.hashCode();
        result = result * 31 + this.profileId.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof DbUserGroupMember)) {
            return false;
        }
        DbUserGroupMember dbUserGroupMember = (DbUserGroupMember)other;
        if (!Intrinsics.areEqual((Object)this.groupId, (Object)dbUserGroupMember.groupId)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.profileId, (Object)dbUserGroupMember.profileId);
    }

    public DbUserGroupMember() {
    }
}

