/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.chat.mobile.model;

import de.justsoftware.chat.exception.ValidationException;
import de.justsoftware.chat.mobile.model.MobileClientVersion;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\b\u0018\u0000 \u00192\u00020\u0001:\u0002\u0018\u0019B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0006\u0010\f\u001a\u00020\rJ\t\u0010\u000e\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000f\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\u0010\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001J\t\u0010\u0016\u001a\u00020\u0017H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u001a"}, d2={"Lde/justsoftware/chat/mobile/model/MobileClientVersion;", "", "client", "Lde/justsoftware/chat/mobile/model/MobileClientVersion$Client;", "versionCode", "", "<init>", "(Lde/justsoftware/chat/mobile/model/MobileClientVersion$Client;J)V", "getClient", "()Lde/justsoftware/chat/mobile/model/MobileClientVersion$Client;", "getVersionCode", "()J", "validate", "", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "Client", "Companion", "chat-service"})
@SourceDebugExtension(value={"SMAP\nMobileClientVersion.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MobileClientVersion.kt\nde/justsoftware/chat/mobile/model/MobileClientVersion\n+ 2 ValidationException.kt\nde/justsoftware/chat/exception/ValidationException$Companion\n+ 3 LoggerUtils.kt\nde/justsoftware/chat/util/LoggerUtilsKt\n*L\n1#1,109:1\n6#2,2:110\n9#3:112\n8#3,3:113\n*S KotlinDebug\n*F\n+ 1 MobileClientVersion.kt\nde/justsoftware/chat/mobile/model/MobileClientVersion\n*L\n29#1:110,2\n37#1:112\n37#1:113,3\n*E\n"})
public final class MobileClientVersion {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Client client;
    private final long versionCode;
    @NotNull
    private static final MobileClientVersion UNKNOWN_CLIENT_VERSION = new MobileClientVersion(Client.UNKNOWN, 0L);
    @NotNull
    private static final Logger LOG;
    @NotNull
    private static final Regex ANDROID_CONNECT_VERSION_CODE_REGEX;
    @NotNull
    private static final Regex ANDROID_SOCIAL_VERSION_CODE_REGEX;
    @NotNull
    private static final Regex IOS_CONNECT_VERSION_CODE_REGEX;
    @NotNull
    private static final Regex IOS_SOCIAL_VERSION_CODE_REGEX;
    @NotNull
    private static final Regex IOS_APP_VERSION_REGEX;

    public MobileClientVersion(@NotNull Client client, long versionCode) {
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        this.client = client;
        this.versionCode = versionCode;
    }

    @NotNull
    public final Client getClient() {
        return this.client;
    }

    public final long getVersionCode() {
        return this.versionCode;
    }

    public final void validate() {
        switch (WhenMappings.$EnumSwitchMapping$0[this.client.ordinal()]) {
            case 1: 
            case 2: {
                throw new ValidationException("The Connect app is not supported anymore.", null, 2, null);
            }
        }
        ValidationException.Companion companion = ValidationException.Companion;
        boolean value$iv = this.versionCode >= this.client.getMinVersion();
        boolean $i$f$validate = false;
        if (!value$iv) {
            boolean bl = false;
            DefaultConstructorMarker defaultConstructorMarker = null;
            int n = 2;
            String string = null;
            String string2 = ("The app version code is too low. Found version " + this.versionCode + ", min version for " + this.client + " is " + this.client.getMinVersion()).toString();
            throw new ValidationException(string2, string, n, defaultConstructorMarker);
        }
    }

    @NotNull
    public final Client component1() {
        return this.client;
    }

    public final long component2() {
        return this.versionCode;
    }

    @NotNull
    public final MobileClientVersion copy(@NotNull Client client, long versionCode) {
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        return new MobileClientVersion(client, versionCode);
    }

    public static /* synthetic */ MobileClientVersion copy$default(MobileClientVersion mobileClientVersion, Client client, long l, int n, Object object) {
        if ((n & 1) != 0) {
            client = mobileClientVersion.client;
        }
        if ((n & 2) != 0) {
            l = mobileClientVersion.versionCode;
        }
        return mobileClientVersion.copy(client, l);
    }

    @NotNull
    public String toString() {
        return "MobileClientVersion(client=" + this.client + ", versionCode=" + this.versionCode + ")";
    }

    public int hashCode() {
        int result = this.client.hashCode();
        result = result * 31 + Long.hashCode(this.versionCode);
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof MobileClientVersion)) {
            return false;
        }
        MobileClientVersion mobileClientVersion = (MobileClientVersion)other;
        if (this.client != mobileClientVersion.client) {
            return false;
        }
        return this.versionCode == mobileClientVersion.versionCode;
    }

    public static final /* synthetic */ MobileClientVersion access$getUNKNOWN_CLIENT_VERSION$cp() {
        return UNKNOWN_CLIENT_VERSION;
    }

    public static final /* synthetic */ Regex access$getANDROID_CONNECT_VERSION_CODE_REGEX$cp() {
        return ANDROID_CONNECT_VERSION_CODE_REGEX;
    }

    public static final /* synthetic */ Regex access$getANDROID_SOCIAL_VERSION_CODE_REGEX$cp() {
        return ANDROID_SOCIAL_VERSION_CODE_REGEX;
    }

    public static final /* synthetic */ Regex access$getIOS_CONNECT_VERSION_CODE_REGEX$cp() {
        return IOS_CONNECT_VERSION_CODE_REGEX;
    }

    public static final /* synthetic */ Regex access$getIOS_SOCIAL_VERSION_CODE_REGEX$cp() {
        return IOS_SOCIAL_VERSION_CODE_REGEX;
    }

    public static final /* synthetic */ Logger access$getLOG$cp() {
        return LOG;
    }

    public static final /* synthetic */ Regex access$getIOS_APP_VERSION_REGEX$cp() {
        return IOS_APP_VERSION_REGEX;
    }

    static {
        Companion $this$logger$iv = Companion;
        boolean $i$f$logger = false;
        Logger logger = LoggerFactory.getLogger(Reflection.getOrCreateKotlinClass(Companion.class).isCompanion() ? Companion.class.getEnclosingClass() : Companion.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        LOG = logger;
        ANDROID_CONNECT_VERSION_CODE_REGEX = new Regex("\\bJustConnect/(\\d+)\\b.*\\(Android/.*");
        ANDROID_SOCIAL_VERSION_CODE_REGEX = new Regex("\\bJustSocial/(\\d+)\\b.*\\(Android/.*");
        IOS_CONNECT_VERSION_CODE_REGEX = new Regex("\\bJustConnect/(\\d+\\.\\d+(?:\\.\\d+)?) Build/\\d+ iOS/");
        IOS_SOCIAL_VERSION_CODE_REGEX = new Regex("\\bJustSocial/(\\d+\\.\\d+(?:\\.\\d+)?) Build/\\d+ iOS/");
        IOS_APP_VERSION_REGEX = new Regex("(\\d+)\\.(\\d+)(?:\\.(\\d+))?");
    }
}

