/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.chat.kafka;

import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.apache.kafka.clients.admin.NewTopic;
import org.jetbrains.annotations.NotNull;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnProperty(value={"kafka.create-topics"}, havingValue="true", matchIfMissing=true)
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\b\u0017\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\fH\u0012J\b\u0010\r\u001a\u00020\tH\u0017J\b\u0010\u000e\u001a\u00020\tH\u0017R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092D\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u0007X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lde/justsoftware/chat/kafka/KafkaTopicConfiguration;", "", "<init>", "()V", "sevenDaysInMs", "", "defaultConfig", "", "topicFactory", "Lorg/apache/kafka/clients/admin/NewTopic;", "topicName", "partitions", "", "pubSubOperationTopic", "chatCoreSearchUpdateIndexTopic", "chat-service"})
public class KafkaTopicConfiguration {
    @NotNull
    private final String sevenDaysInMs;
    @NotNull
    private final Map<String, String> defaultConfig;

    public KafkaTopicConfiguration() {
        this.sevenDaysInMs = "604800000";
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"delete.retention.ms", (Object)this.sevenDaysInMs), TuplesKt.to((Object)"segment.ms", (Object)this.sevenDaysInMs), TuplesKt.to((Object)"cleanup.policy", (Object)"delete")};
        this.defaultConfig = MapsKt.mapOf((Pair[])pairArray);
    }

    private NewTopic topicFactory(String topicName, int partitions) {
        NewTopic topic = new NewTopic(topicName, partitions, 1);
        NewTopic newTopic = topic.configs(this.defaultConfig);
        Intrinsics.checkNotNullExpressionValue((Object)newTopic, (String)"configs(...)");
        return newTopic;
    }

    @Bean
    @NotNull
    public NewTopic pubSubOperationTopic() {
        return this.topicFactory("just.chat.pubSub.operations", 5);
    }

    @Bean
    @NotNull
    public NewTopic chatCoreSearchUpdateIndexTopic() {
        return this.topicFactory("just.chat-service.search.chat.updateIndex", 5);
    }
}

