/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.chat.config.security;

import de.justsoftware.chat.config.security.WebSecurityConfiguration;
import de.justsoftware.jwtfilter.JwtAuthenticationProcessingFilter;
import de.justsoftware.jwtfilter.verifier.JwtVerifier;
import jakarta.servlet.Filter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.SpreadBuilder;
import org.jetbrains.annotations.NotNull;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.security.config.Customizer;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configuration.EnableWebSecurity;
import org.springframework.security.config.annotation.web.configurers.AuthorizeHttpRequestsConfigurer;
import org.springframework.security.config.annotation.web.configurers.CsrfConfigurer;
import org.springframework.security.config.annotation.web.configurers.HeadersConfigurer;
import org.springframework.security.config.annotation.web.configurers.SessionManagementConfigurer;
import org.springframework.security.config.http.SessionCreationPolicy;
import org.springframework.security.web.SecurityFilterChain;
import org.springframework.security.web.authentication.preauth.AbstractPreAuthenticatedProcessingFilter;
import org.springframework.security.web.servlet.util.matcher.PathPatternRequestMatcher;
import org.springframework.security.web.util.matcher.OrRequestMatcher;
import org.springframework.security.web.util.matcher.RequestMatcher;

@Configuration
@EnableWebSecurity
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0017\u0018\u0000 \n2\u00020\u0001:\u0001\nB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017\u00a8\u0006\u000b"}, d2={"Lde/justsoftware/chat/config/security/WebSecurityConfiguration;", "", "<init>", "()V", "configureSecurity", "Lorg/springframework/security/web/SecurityFilterChain;", "http", "Lorg/springframework/security/config/annotation/web/builders/HttpSecurity;", "jwtVerifier", "Lde/justsoftware/jwtfilter/verifier/JwtVerifier;", "Companion", "chat-service"})
@SourceDebugExtension(value={"SMAP\nWebSecurityConfiguration.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WebSecurityConfiguration.kt\nde/justsoftware/chat/config/security/WebSecurityConfiguration\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,58:1\n11561#2:59\n11896#2,3:60\n*S KotlinDebug\n*F\n+ 1 WebSecurityConfiguration.kt\nde/justsoftware/chat/config/security/WebSecurityConfiguration\n*L\n29#1:59\n29#1:60,3\n*E\n"})
public class WebSecurityConfiguration {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final String INTERNAL_API = "/internal/**";
    @NotNull
    private static final String[] SWAGGER_RESOURCES;

    /*
     * WARNING - void declaration
     */
    @Bean
    @NotNull
    public SecurityFilterChain configureSecurity(@NotNull HttpSecurity http, @NotNull JwtVerifier jwtVerifier) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)http, (String)"http");
        Intrinsics.checkNotNullParameter((Object)jwtVerifier, (String)"jwtVerifier");
        Object[] objectArray = ArraysKt.plus((Object[])SWAGGER_RESOURCES, (Object)INTERNAL_API);
        JwtAuthenticationProcessingFilter jwtAuthenticationProcessingFilter = new JwtAuthenticationProcessingFilter(jwtVerifier);
        boolean $i$f$map = false;
        void var6_6 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(((void)$this$map$iv).length);
        boolean $i$f$mapTo = false;
        for (void item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(PathPatternRequestMatcher.withDefaults().matcher((String)it));
        }
        List list = (List)destination$iv$iv;
        JwtAuthenticationProcessingFilter jwtAuthenticationProcessingFilter2 = jwtAuthenticationProcessingFilter.applyIgnoreFilterMatcher((RequestMatcher)new OrRequestMatcher(list));
        Intrinsics.checkNotNullExpressionValue((Object)jwtAuthenticationProcessingFilter2, (String)"applyIgnoreFilterMatcher(...)");
        JwtAuthenticationProcessingFilter jwt = jwtAuthenticationProcessingFilter2;
        http.sessionManagement(WebSecurityConfiguration::configureSecurity$lambda$1).exceptionHandling(Customizer.withDefaults()).csrf(WebSecurityConfiguration::configureSecurity$lambda$2).headers(WebSecurityConfiguration::configureSecurity$lambda$3).anonymous(Customizer.withDefaults()).authorizeHttpRequests(WebSecurityConfiguration::configureSecurity$lambda$4).addFilterAfter((Filter)jwt, AbstractPreAuthenticatedProcessingFilter.class);
        Object object = http.build();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"build(...)");
        return (SecurityFilterChain)object;
    }

    private static final void configureSecurity$lambda$1(SessionManagementConfigurer it) {
        it.sessionCreationPolicy(SessionCreationPolicy.STATELESS);
    }

    private static final void configureSecurity$lambda$2(CsrfConfigurer it) {
        it.disable();
    }

    private static final void configureSecurity$lambda$3(HeadersConfigurer it) {
        it.cacheControl(Customizer.withDefaults());
    }

    private static final void configureSecurity$lambda$4(AuthorizeHttpRequestsConfigurer.AuthorizationManagerRequestMatcherRegistry it) {
        SpreadBuilder spreadBuilder = new SpreadBuilder(2);
        spreadBuilder.addSpread((Object)SWAGGER_RESOURCES);
        spreadBuilder.add((Object)INTERNAL_API);
        ((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)it.requestMatchers((String[])spreadBuilder.toArray((Object[])new String[spreadBuilder.size()]))).permitAll();
        ((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)it.anyRequest()).fullyAuthenticated();
    }

    static {
        String[] stringArray = new String[]{"/v3/api-docs/**", "/swagger-ui/**"};
        SWAGGER_RESOURCES = stringArray;
    }
}

