/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.chat.config;

import de.justsoftware.chat.exception.ValidationException;
import de.justsoftware.chat.mobile.model.MobileClientVersion;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.springframework.http.HttpStatus;
import org.springframework.web.servlet.HandlerInterceptor;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\f"}, d2={"Lde/justsoftware/chat/config/MobileAppVersionCheckInterceptor;", "Lorg/springframework/web/servlet/HandlerInterceptor;", "<init>", "()V", "preHandle", "", "request", "Ljakarta/servlet/http/HttpServletRequest;", "response", "Ljakarta/servlet/http/HttpServletResponse;", "handler", "", "chat-service"})
public final class MobileAppVersionCheckInterceptor
implements HandlerInterceptor {
    @NotNull
    public static final MobileAppVersionCheckInterceptor INSTANCE = new MobileAppVersionCheckInterceptor();

    private MobileAppVersionCheckInterceptor() {
    }

    public boolean preHandle(@NotNull HttpServletRequest request, @NotNull HttpServletResponse response2, @NotNull Object handler) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)response2, (String)"response");
        Intrinsics.checkNotNullParameter((Object)handler, (String)"handler");
        try {
            MobileClientVersion.Companion.toClientVersion(request).validate();
            bl = true;
        }
        catch (ValidationException e) {
            response2.sendError(HttpStatus.PRECONDITION_FAILED.value(), e.getMessage());
            bl = false;
        }
        return bl;
    }
}

